/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FifoRpcScheduler
extends RpcScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(FifoRpcScheduler.class);
    private final int handlerCount;
    private final int maxQueueLength;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private ThreadPoolExecutor executor;

    public FifoRpcScheduler(Configuration conf, int handlerCount) {
        this.handlerCount = handlerCount;
        this.maxQueueLength = conf.getInt("hbase.ipc.server.max.callqueue.length", handlerCount * 10);
        LOG.info("Using " + this.getClass().getSimpleName() + " as user call queue; handlerCount=" + handlerCount + "; maxQueueLength=" + this.maxQueueLength);
    }

    @Override
    public void init(RpcScheduler.Context context) {
    }

    @Override
    public void start() {
        this.executor = new ThreadPoolExecutor(this.handlerCount, this.handlerCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxQueueLength), new DaemonThreadFactory("FifoRpcScheduler.handler"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    @Override
    public boolean dispatch(final CallRunner task) throws IOException, InterruptedException {
        int queued = this.queueSize.getAndIncrement();
        if (this.maxQueueLength > 0 && queued >= this.maxQueueLength) {
            this.queueSize.decrementAndGet();
            return false;
        }
        this.executor.execute(new FifoCallRunner(task){

            @Override
            public void run() {
                task.setStatus(RpcServer.getStatus());
                task.run();
                FifoRpcScheduler.this.queueSize.decrementAndGet();
            }
        });
        return true;
    }

    @Override
    public int getGeneralQueueLength() {
        return this.executor.getQueue().size();
    }

    @Override
    public int getPriorityQueueLength() {
        return 0;
    }

    @Override
    public int getReplicationQueueLength() {
        return 0;
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long getNumGeneralCallsDropped() {
        return 0L;
    }

    @Override
    public long getNumLifoModeSwitches() {
        return 0L;
    }

    @Override
    public int getWriteQueueLength() {
        return 0;
    }

    @Override
    public int getReadQueueLength() {
        return 0;
    }

    @Override
    public int getScanQueueLength() {
        return 0;
    }

    @Override
    public int getActiveWriteRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveReadRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveScanRpcHandlerCount() {
        return 0;
    }

    @Override
    public CallQueueInfo getCallQueueInfo() {
        String queueName = "Fifo Queue";
        HashMap<String, Long> methodCount = new HashMap<String, Long>();
        HashMap<String, Long> methodSize = new HashMap<String, Long>();
        CallQueueInfo callQueueInfo = new CallQueueInfo();
        callQueueInfo.setCallMethodCount(queueName, methodCount);
        callQueueInfo.setCallMethodSize(queueName, methodSize);
        for (Runnable r : this.executor.getQueue()) {
            String method;
            FifoCallRunner mcr = (FifoCallRunner)r;
            RpcCall rpcCall = mcr.getCallRunner().getRpcCall();
            if (null == rpcCall.getMethod() || StringUtil.isNullOrEmpty((String)(method = rpcCall.getMethod().getName()))) {
                method = "Unknown";
            }
            long size = rpcCall.getSize();
            methodCount.put(method, 1L + methodCount.getOrDefault(method, 0L));
            methodSize.put(method, size + methodSize.getOrDefault(method, 0L));
        }
        return callQueueInfo;
    }

    private static class FifoCallRunner
    implements Runnable {
        private final CallRunner callRunner;

        FifoCallRunner(CallRunner cr) {
            this.callRunner = cr;
        }

        CallRunner getCallRunner() {
            return this.callRunner;
        }

        @Override
        public void run() {
            this.callRunner.run();
        }
    }
}

