/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutputHelper;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufLogWriter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Throwables;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AsyncProtobufLogWriter
extends AbstractProtobufLogWriter
implements AsyncFSWALProvider.AsyncWriter {
    private static final Log LOG = LogFactory.getLog(AsyncProtobufLogWriter.class);
    private final EventLoop eventLoop;
    private final Class<? extends Channel> channelClass;
    private AsyncFSOutput output;
    private OutputStream asyncOutputWrapper;

    public AsyncProtobufLogWriter(EventLoop eventLoop, Class<? extends Channel> channelClass) {
        this.eventLoop = eventLoop;
        this.channelClass = channelClass;
    }

    @Override
    public void append(WAL.Entry entry) {
        int buffered = this.output.buffered();
        entry.setCompressionContext(this.compressionContext);
        try {
            entry.getKey().getBuilder(this.compressor).setFollowingKvCount(entry.getEdit().size()).build().writeDelimitedTo(this.asyncOutputWrapper);
        }
        catch (IOException e) {
            throw new AssertionError("should not happen", e);
        }
        try {
            for (Cell cell : entry.getEdit().getCells()) {
                this.cellEncoder.write(cell);
            }
        }
        catch (IOException e) {
            throw new AssertionError("should not happen", e);
        }
        this.length.addAndGet(this.output.buffered() - buffered);
    }

    @Override
    public CompletableFuture<Long> sync() {
        return this.output.flush(false);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.output == null) {
            return;
        }
        try {
            this.writeWALTrailer();
            this.output.close();
        }
        catch (Exception e) {
            LOG.warn((Object)"normal close failed, try recover", (Throwable)e);
            this.output.recoverAndClose(null);
        }
        this.output = null;
    }

    public AsyncFSOutput getOutput() {
        return this.output;
    }

    @Override
    protected void initOutput(FileSystem fs, Path path, boolean overwritable, int bufferSize, short replication, long blockSize) throws IOException {
        this.output = AsyncFSOutputHelper.createOutput(fs, path, overwritable, false, replication, blockSize, this.eventLoop, this.channelClass);
        this.asyncOutputWrapper = new OutputStreamWrapper(this.output);
    }

    private long write(Consumer<CompletableFuture<Long>> action) throws IOException {
        CompletableFuture future = new CompletableFuture();
        this.eventLoop.execute(() -> action.accept(future));
        try {
            return (Long)future.get();
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    protected long writeMagicAndWALHeader(byte[] magic, WALProtos.WALHeader header) throws IOException {
        return this.write(future -> {
            this.output.write(magic);
            try {
                header.writeDelimitedTo(this.asyncOutputWrapper);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.output.flush(false).whenComplete((len, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else {
                    future.complete(len);
                }
            });
        });
    }

    @Override
    protected long writeWALTrailerAndMagic(WALProtos.WALTrailer trailer, byte[] magic) throws IOException {
        return this.write(future -> {
            try {
                trailer.writeTo(this.asyncOutputWrapper);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.output.writeInt(trailer.getSerializedSize());
            this.output.write(magic);
            this.output.flush(false).whenComplete((len, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else {
                    future.complete(len);
                }
            });
        });
    }

    @Override
    protected OutputStream getOutputStreamForCellEncoder() {
        return this.asyncOutputWrapper;
    }

    private static final class OutputStreamWrapper
    extends OutputStream
    implements ByteBufferWriter {
        private final AsyncFSOutput out;
        private final byte[] oneByteBuf = new byte[1];

        @Override
        public void write(int b) throws IOException {
            this.oneByteBuf[0] = (byte)b;
            this.write(this.oneByteBuf);
        }

        public OutputStreamWrapper(AsyncFSOutput out) {
            this.out = out;
        }

        public void write(ByteBuffer b, int off, int len) throws IOException {
            ByteBuffer bb = b.duplicate();
            bb.position(off);
            bb.limit(off + len);
            this.out.write(bb);
        }

        public void writeInt(int i) throws IOException {
            this.out.writeInt(i);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

