/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactionRequestImpl
implements CompactionRequest {
    private boolean isOffPeak = false;
    private DisplayCompactionType isMajor = DisplayCompactionType.MINOR;
    private int priority = Integer.MIN_VALUE;
    private Collection<HStoreFile> filesToCompact;
    private long selectionTime;
    private String regionName = "";
    private String storeName = "";
    private long totalSize = -1L;
    private CompactionLifeCycleTracker tracker = CompactionLifeCycleTracker.DUMMY;

    public CompactionRequestImpl(Collection<HStoreFile> files) {
        this.selectionTime = EnvironmentEdgeManager.currentTime();
        this.filesToCompact = (Collection)Preconditions.checkNotNull(files, (Object)"files for compaction can not null");
        this.recalculateSize();
    }

    public void updateFiles(Collection<HStoreFile> files) {
        this.filesToCompact = (Collection)Preconditions.checkNotNull(files, (Object)"files for compaction can not null");
        this.recalculateSize();
    }

    public Collection<HStoreFile> getFiles() {
        return Collections.unmodifiableCollection(this.filesToCompact);
    }

    public void setDescription(String regionName, String storeName) {
        this.regionName = regionName;
        this.storeName = storeName;
    }

    @Override
    public long getSize() {
        return this.totalSize;
    }

    @Override
    public boolean isAllFiles() {
        return this.isMajor == DisplayCompactionType.MAJOR || this.isMajor == DisplayCompactionType.ALL_FILES;
    }

    @Override
    public boolean isMajor() {
        return this.isMajor == DisplayCompactionType.MAJOR;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public boolean isOffPeak() {
        return this.isOffPeak;
    }

    public void setOffPeak(boolean value) {
        this.isOffPeak = value;
    }

    @Override
    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setIsMajor(boolean isMajor, boolean isAllFiles) {
        assert (isAllFiles || !isMajor);
        this.isMajor = !isAllFiles ? DisplayCompactionType.MINOR : (isMajor ? DisplayCompactionType.MAJOR : DisplayCompactionType.ALL_FILES);
    }

    public void setTracker(CompactionLifeCycleTracker tracker) {
        this.tracker = tracker;
    }

    public CompactionLifeCycleTracker getTracker() {
        return this.tracker;
    }

    public String toString() {
        String fsList = this.filesToCompact.stream().filter(f -> f.getReader() != null).map(f -> StringUtils.TraditionalBinaryPrefix.long2String((long)f.getReader().length(), (String)"", (int)1)).collect(Collectors.joining(", "));
        return "regionName=" + this.regionName + ", storeName=" + this.storeName + ", fileCount=" + this.getFiles().size() + ", fileSize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.totalSize, (String)"", (int)1) + (fsList.isEmpty() ? "" : " (" + fsList + ")") + ", priority=" + this.priority + ", time=" + this.selectionTime;
    }

    private void recalculateSize() {
        this.totalSize = this.filesToCompact.stream().map(HStoreFile::getReader).mapToLong(r -> r != null ? r.length() : 0L).sum();
    }

    private static enum DisplayCompactionType {
        MINOR,
        ALL_FILES,
        MAJOR;

    }
}

