/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.policies.NoWritesViolationPolicyEnforcement;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoWritesCompactionsViolationPolicyEnforcement
extends NoWritesViolationPolicyEnforcement {
    private static final Log LOG = LogFactory.getLog(NoWritesCompactionsViolationPolicyEnforcement.class);
    private AtomicBoolean disableCompactions = new AtomicBoolean(false);

    @Override
    public synchronized void enable() {
        boolean ret = this.disableCompactions.compareAndSet(false, true);
        if (!ret && LOG.isTraceEnabled()) {
            LOG.trace((Object)"Compactions were already disabled upon enabling the policy");
        }
    }

    @Override
    public synchronized void disable() {
        boolean ret = this.disableCompactions.compareAndSet(true, false);
        if (!ret && LOG.isTraceEnabled()) {
            LOG.trace((Object)"Compactions were already enabled upon disabling the policy");
        }
    }

    @Override
    public String getPolicyName() {
        return SpaceViolationPolicy.NO_WRITES_COMPACTIONS.name();
    }

    @Override
    public boolean areCompactionsDisabled() {
        return this.disableCompactions.get();
    }
}

