/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.locking;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class LockProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(LockProcedure.class);
    public static final int DEFAULT_REMOTE_LOCKS_TIMEOUT_MS = 30000;
    public static final String REMOTE_LOCKS_TIMEOUT_MS_CONF = "hbase.master.procedure.remote.locks.timeout.ms";
    public static final int DEFAULT_LOCAL_MASTER_LOCKS_TIMEOUT_MS = 600000;
    public static final String LOCAL_MASTER_LOCKS_TIMEOUT_MS_CONF = "hbase.master.procedure.local.master.locks.timeout.ms";
    private String namespace;
    private TableName tableName;
    private RegionInfo[] regionInfos;
    private LockType type;
    private LockInterface lock;
    private TableProcedureInterface.TableOperationType opType;
    private String description;
    private boolean recoveredMasterLock;
    private boolean hasLock;
    private final ProcedureEvent<LockProcedure> event = new ProcedureEvent((Object)this);
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final AtomicLong lastHeartBeat = new AtomicLong();
    private final AtomicBoolean unlock = new AtomicBoolean(false);
    private final CountDownLatch lockAcquireLatch;

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return this.opType;
    }

    public LockProcedure() {
        this.lockAcquireLatch = null;
    }

    private LockProcedure(Configuration conf, LockType type, String description, CountDownLatch lockAcquireLatch) {
        this.type = type;
        this.description = description;
        this.lockAcquireLatch = lockAcquireLatch;
        if (lockAcquireLatch == null) {
            this.setTimeout(conf.getInt(REMOTE_LOCKS_TIMEOUT_MS_CONF, 30000));
        } else {
            this.setTimeout(conf.getInt(LOCAL_MASTER_LOCKS_TIMEOUT_MS_CONF, 600000));
        }
    }

    public LockProcedure(Configuration conf, String namespace, LockType type, String description, CountDownLatch lockAcquireLatch) throws IllegalArgumentException {
        this(conf, type, description, lockAcquireLatch);
        if (namespace.isEmpty()) {
            throw new IllegalArgumentException("Empty namespace");
        }
        this.namespace = namespace;
        this.lock = this.setupNamespaceLock();
    }

    public LockProcedure(Configuration conf, TableName tableName, LockType type, String description, CountDownLatch lockAcquireLatch) throws IllegalArgumentException {
        this(conf, type, description, lockAcquireLatch);
        this.tableName = tableName;
        this.lock = this.setupTableLock();
    }

    public LockProcedure(Configuration conf, RegionInfo[] regionInfos, LockType type, String description, CountDownLatch lockAcquireLatch) throws IllegalArgumentException {
        this(conf, type, description, lockAcquireLatch);
        if (regionInfos.length == 0) {
            throw new IllegalArgumentException("No regions specified for region lock");
        }
        TableName regionTable = regionInfos[0].getTable();
        for (int i = 1; i < regionInfos.length; ++i) {
            if (regionInfos[i].getTable().equals((Object)regionTable)) continue;
            throw new IllegalArgumentException("All regions should be from same table");
        }
        this.regionInfos = regionInfos;
        this.lock = this.setupRegionLock();
    }

    private boolean hasHeartbeatExpired() {
        return System.currentTimeMillis() - this.lastHeartBeat.get() >= (long)this.getTimeout();
    }

    public void updateHeartBeat() {
        this.lastHeartBeat.set(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Heartbeat " + this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTimeoutFailure(MasterProcedureEnv env) {
        ProcedureEvent<LockProcedure> procedureEvent = this.event;
        synchronized (procedureEvent) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Timeout failure " + this.event));
            }
            if (!this.event.isReady()) {
                this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Calling wake on " + this.event));
                }
                env.getProcedureScheduler().wakeEvent(this.event);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(MasterProcedureEnv env) {
        this.unlock.set(true);
        this.locked.set(false);
        ProcedureEvent<LockProcedure> procedureEvent = this.event;
        synchronized (procedureEvent) {
            if (!this.event.isReady()) {
                this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
                env.getProcedureScheduler().wakeEvent(this.event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
        if (this.recoveredMasterLock) {
            return null;
        }
        if (this.lockAcquireLatch != null) {
            this.lockAcquireLatch.countDown();
        }
        if (this.unlock.get() || this.hasHeartbeatExpired()) {
            this.locked.set(false);
            LOG.debug((Object)((this.unlock.get() ? "UNLOCKED " : "TIMED OUT ") + this.toString()));
            return null;
        }
        ProcedureEvent<LockProcedure> procedureEvent = this.event;
        synchronized (procedureEvent) {
            env.getProcedureScheduler().suspendEvent(this.event);
            env.getProcedureScheduler().waitEvent(this.event, this);
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        }
        throw new ProcedureSuspendedException();
    }

    protected void rollback(MasterProcedureEnv env) {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        this.unlock(env);
        return true;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        LockServiceProtos.LockProcedureData.Builder builder = LockServiceProtos.LockProcedureData.newBuilder().setLockType(LockServiceProtos.LockType.valueOf((String)this.type.name())).setDescription(this.description);
        if (this.regionInfos != null) {
            for (int i = 0; i < this.regionInfos.length; ++i) {
                builder.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.regionInfos[i]));
            }
        } else if (this.namespace != null) {
            builder.setNamespace(this.namespace);
        } else if (this.tableName != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        }
        if (this.lockAcquireLatch != null) {
            builder.setIsMasterLock(true);
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        LockServiceProtos.LockProcedureData state = (LockServiceProtos.LockProcedureData)serializer.deserialize(LockServiceProtos.LockProcedureData.class);
        this.type = LockType.valueOf((String)state.getLockType().name());
        this.description = state.getDescription();
        if (state.getRegionInfoCount() > 0) {
            this.regionInfos = new RegionInfo[state.getRegionInfoCount()];
            for (int i = 0; i < state.getRegionInfoCount(); ++i) {
                this.regionInfos[i] = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)state.getRegionInfo(i));
            }
        } else if (state.hasNamespace()) {
            this.namespace = state.getNamespace();
        } else if (state.hasTableName()) {
            this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)state.getTableName());
        }
        this.recoveredMasterLock = state.getIsMasterLock();
        this.lock = this.setupLock();
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        boolean ret = this.lock.acquireLock(env);
        this.locked.set(ret);
        this.hasLock = ret;
        if (ret) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("LOCKED " + this.toString()));
            }
            this.lastHeartBeat.set(System.currentTimeMillis());
            return Procedure.LockState.LOCK_ACQUIRED;
        }
        LOG.warn((Object)("Failed acquire LOCK " + this.toString() + "; YIELDING"));
        return Procedure.LockState.LOCK_EVENT_WAIT;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        this.lock.releaseLock(env);
        this.hasLock = false;
    }

    protected void beforeReplay(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
    }

    protected void toStringClassDetails(StringBuilder builder) {
        super.toStringClassDetails(builder);
        if (this.regionInfos != null) {
            builder.append(" regions=");
            for (int i = 0; i < this.regionInfos.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(this.regionInfos[i].getShortNameToLog());
            }
        } else if (this.namespace != null) {
            builder.append(", namespace=").append(this.namespace);
        } else if (this.tableName != null) {
            builder.append(", tableName=").append(this.tableName);
        }
        builder.append(", type=").append(this.type);
    }

    public LockType getType() {
        return this.type;
    }

    private LockInterface setupLock() throws IllegalArgumentException {
        if (this.regionInfos != null) {
            return this.setupRegionLock();
        }
        if (this.namespace != null) {
            return this.setupNamespaceLock();
        }
        if (this.tableName != null) {
            return this.setupTableLock();
        }
        LOG.error((Object)("Unknown level specified in " + this.toString()));
        throw new IllegalArgumentException("no namespace/table/region provided");
    }

    private LockInterface setupNamespaceLock() throws IllegalArgumentException {
        this.tableName = TableName.NAMESPACE_TABLE_NAME;
        switch (this.type) {
            case EXCLUSIVE: {
                this.opType = TableProcedureInterface.TableOperationType.EDIT;
                return new NamespaceExclusiveLock();
            }
            case SHARED: {
                LOG.error((Object)("Shared lock on namespace not supported for " + this.toString()));
                throw new IllegalArgumentException("Shared lock on namespace not supported");
            }
        }
        LOG.error((Object)("Unexpected lock type " + this.toString()));
        throw new IllegalArgumentException("Wrong lock type: " + this.type.toString());
    }

    private LockInterface setupTableLock() throws IllegalArgumentException {
        switch (this.type) {
            case EXCLUSIVE: {
                this.opType = TableProcedureInterface.TableOperationType.EDIT;
                return new TableExclusiveLock();
            }
            case SHARED: {
                this.opType = TableProcedureInterface.TableOperationType.READ;
                return new TableSharedLock();
            }
        }
        LOG.error((Object)("Unexpected lock type " + this.toString()));
        throw new IllegalArgumentException("Wrong lock type:" + this.type.toString());
    }

    private LockInterface setupRegionLock() throws IllegalArgumentException {
        this.tableName = this.regionInfos[0].getTable();
        switch (this.type) {
            case EXCLUSIVE: {
                this.opType = TableProcedureInterface.TableOperationType.REGION_EDIT;
                return new RegionExclusiveLock();
            }
        }
        LOG.error((Object)("Only exclusive lock supported on regions for " + this.toString()));
        throw new IllegalArgumentException("Only exclusive lock supported on regions.");
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    public boolean hasLock(MasterProcedureEnv env) {
        return this.hasLock;
    }

    private class RegionExclusiveLock
    implements LockInterface {
        private RegionExclusiveLock() {
        }

        @Override
        public boolean acquireLock(MasterProcedureEnv env) {
            return !env.getProcedureScheduler().waitRegions(LockProcedure.this, LockProcedure.this.tableName, LockProcedure.this.regionInfos);
        }

        @Override
        public void releaseLock(MasterProcedureEnv env) {
            env.getProcedureScheduler().wakeRegions(LockProcedure.this, LockProcedure.this.tableName, LockProcedure.this.regionInfos);
        }
    }

    private class NamespaceExclusiveLock
    implements LockInterface {
        private NamespaceExclusiveLock() {
        }

        @Override
        public boolean acquireLock(MasterProcedureEnv env) {
            return !env.getProcedureScheduler().waitNamespaceExclusiveLock(LockProcedure.this, LockProcedure.this.namespace);
        }

        @Override
        public void releaseLock(MasterProcedureEnv env) {
            env.getProcedureScheduler().wakeNamespaceExclusiveLock(LockProcedure.this, LockProcedure.this.namespace);
        }
    }

    private class TableSharedLock
    implements LockInterface {
        private TableSharedLock() {
        }

        @Override
        public boolean acquireLock(MasterProcedureEnv env) {
            return !env.getProcedureScheduler().waitTableSharedLock(LockProcedure.this, LockProcedure.this.tableName);
        }

        @Override
        public void releaseLock(MasterProcedureEnv env) {
            env.getProcedureScheduler().wakeTableSharedLock(LockProcedure.this, LockProcedure.this.tableName);
        }
    }

    private class TableExclusiveLock
    implements LockInterface {
        private TableExclusiveLock() {
        }

        @Override
        public boolean acquireLock(MasterProcedureEnv env) {
            return !env.getProcedureScheduler().waitTableExclusiveLock(LockProcedure.this, LockProcedure.this.tableName);
        }

        @Override
        public void releaseLock(MasterProcedureEnv env) {
            env.getProcedureScheduler().wakeTableExclusiveLock(LockProcedure.this, LockProcedure.this.tableName);
        }
    }

    private static interface LockInterface {
        public boolean acquireLock(MasterProcedureEnv var1);

        public void releaseLock(MasterProcedureEnv var1);
    }
}

