/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.CellProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MessageCodec
implements Codec {
    public Codec.Decoder getDecoder(InputStream is) {
        return new MessageDecoder(is);
    }

    public Codec.Decoder getDecoder(ByteBuff buf) {
        return this.getDecoder((InputStream)new ByteBuffInputStream(buf));
    }

    public Codec.Encoder getEncoder(OutputStream os) {
        return new MessageEncoder(os);
    }

    static class MessageDecoder
    extends BaseDecoder {
        private final ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);

        MessageDecoder(InputStream in) {
            super(in);
        }

        protected Cell parseCell() throws IOException {
            return ProtobufUtil.toCell((ExtendedCellBuilder)this.cellBuilder, (CellProtos.Cell)CellProtos.Cell.parseDelimitedFrom((InputStream)this.in));
        }
    }

    static class MessageEncoder
    extends BaseEncoder {
        MessageEncoder(OutputStream out) {
            super(out);
        }

        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
            builder.setRow(UnsafeByteOperations.unsafeWrap((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
            builder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
            builder.setQualifier(UnsafeByteOperations.unsafeWrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            builder.setTimestamp(cell.getTimestamp());
            builder.setCellType(CellProtos.CellType.valueOf((int)cell.getTypeByte()));
            builder.setValue(UnsafeByteOperations.unsafeWrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            CellProtos.Cell pbcell = builder.build();
            pbcell.writeDelimitedTo(this.out);
        }
    }
}

