/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
class DisabledWALProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(DisabledWALProvider.class);
    WAL disabled;

    DisabledWALProvider() {
    }

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (null != this.disabled) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        if (null == providerId) {
            providerId = "defaultDisabled";
        }
        this.disabled = new DisabledWAL(new Path(FSUtils.getWALRootDir(conf), providerId), conf, null);
    }

    @Override
    public List<WAL> getWALs() throws IOException {
        ArrayList<WAL> wals = new ArrayList<WAL>();
        wals.add(this.disabled);
        return wals;
    }

    @Override
    public WAL getWAL(byte[] identifier, byte[] namespace) throws IOException {
        return this.disabled;
    }

    @Override
    public void close() throws IOException {
        this.disabled.close();
    }

    @Override
    public void shutdown() throws IOException {
        this.disabled.shutdown();
    }

    @Override
    public long getNumLogFiles() {
        return 0L;
    }

    @Override
    public long getLogFileSize() {
        return 0L;
    }

    private static class DisabledWAL
    implements WAL {
        protected final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
        protected final Path path;
        protected final WALCoprocessorHost coprocessorHost;
        protected final AtomicBoolean closed = new AtomicBoolean(false);

        public DisabledWAL(Path path, Configuration conf, List<WALActionsListener> listeners) {
            this.coprocessorHost = new WALCoprocessorHost(this, conf);
            this.path = path;
            if (null != listeners) {
                for (WALActionsListener listener : listeners) {
                    this.registerWALActionsListener(listener);
                }
            }
        }

        @Override
        public void registerWALActionsListener(WALActionsListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public boolean unregisterWALActionsListener(WALActionsListener listener) {
            return this.listeners.remove(listener);
        }

        @Override
        public byte[][] rollWriter() {
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.logRollRequested(false);
                }
                for (WALActionsListener listener : this.listeners) {
                    try {
                        listener.preLogRoll(this.path, this.path);
                    }
                    catch (IOException exception) {
                        LOG.debug((Object)"Ignoring exception from listener.", (Throwable)exception);
                    }
                }
                for (WALActionsListener listener : this.listeners) {
                    try {
                        listener.postLogRoll(this.path, this.path);
                    }
                    catch (IOException exception) {
                        LOG.debug((Object)"Ignoring exception from listener.", (Throwable)exception);
                    }
                }
            }
            return null;
        }

        @Override
        public byte[][] rollWriter(boolean force) {
            return this.rollWriter();
        }

        @Override
        public void shutdown() {
            if (this.closed.compareAndSet(false, true) && !this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.logCloseRequested();
                }
            }
        }

        @Override
        public void close() {
            this.shutdown();
        }

        @Override
        public long append(HTableDescriptor htd, HRegionInfo info, WALKey key, WALEdit edits, boolean inMemstore) throws IOException {
            MultiVersionConcurrencyControl.WriteEntry writeEntry = key.getMvcc().begin();
            if (!edits.isReplay()) {
                for (Cell cell : edits.getCells()) {
                    CellUtil.setSequenceId((Cell)cell, (long)writeEntry.getWriteNumber());
                }
            }
            key.setWriteEntry(writeEntry);
            if (!this.listeners.isEmpty()) {
                long start = System.nanoTime();
                long len = 0L;
                for (Cell cell : edits.getCells()) {
                    len += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
                }
                long elapsed = (System.nanoTime() - start) / 1000000L;
                for (WALActionsListener listener : this.listeners) {
                    listener.postAppend(len, elapsed, key, edits);
                }
            }
            return -1L;
        }

        @Override
        public void sync() {
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.postSync(0L, 0);
                }
            }
        }

        @Override
        public void sync(long txid) {
            this.sync();
        }

        @Override
        public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> flushedFamilyNames) {
            if (this.closed.get()) {
                return null;
            }
            return -1L;
        }

        @Override
        public void completeCacheFlush(byte[] encodedRegionName) {
        }

        @Override
        public void abortCacheFlush(byte[] encodedRegionName) {
        }

        @Override
        public WALCoprocessorHost getCoprocessorHost() {
            return this.coprocessorHost;
        }

        @Override
        public long getEarliestMemstoreSeqNum(byte[] encodedRegionName) {
            return -1L;
        }

        @Override
        public long getEarliestMemstoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
            return -1L;
        }

        @Override
        public String toString() {
            return "WAL disabled.";
        }
    }
}

