/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.CellSkipListSet;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellSkipListSet
extends TestCase {
    private final CellSkipListSet csls = new CellSkipListSet(KeyValue.COMPARATOR);

    protected void setUp() throws Exception {
        super.setUp();
        this.csls.clear();
    }

    public void testAdd() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.csls.add((Cell)kv);
        TestCellSkipListSet.assertTrue((boolean)this.csls.contains((Object)kv));
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.size());
        Cell first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)kv.equals((Object)first));
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])first.getValue()));
        byte[] overwriteValue = Bytes.toBytes((String)"overwrite");
        KeyValue overwrite = new KeyValue(bytes, bytes, bytes, overwriteValue);
        this.csls.add((Cell)overwrite);
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.size());
        first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])overwrite.getValue(), (byte[])first.getValue()));
        TestCellSkipListSet.assertFalse((boolean)Bytes.equals((byte[])overwrite.getValue(), (byte[])kv.getValue()));
    }

    public void testIterator() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value1));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value2));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testDescendingIterator() throws Exception {
        Cell kv;
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        Iterator i = this.csls.descendingIterator();
        while (i.hasNext()) {
            kv = (Cell)i.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value1));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i2)), value2));
        }
        count = 0;
        Iterator i3 = this.csls.descendingIterator();
        while (i3.hasNext()) {
            kv = (Cell)i3.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value2));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testHeadTail() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        KeyValue splitter = null;
        for (int i = 0; i < 3; ++i) {
            KeyValue kv = new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1);
            if (i == 1) {
                splitter = kv;
            }
            this.csls.add((Cell)kv);
        }
        SortedSet tail = this.csls.tailSet(splitter);
        TestCellSkipListSet.assertEquals((int)2, (int)tail.size());
        SortedSet head = this.csls.headSet(splitter);
        TestCellSkipListSet.assertEquals((int)1, (int)head.size());
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        tail = this.csls.tailSet((Cell)splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((Cell)tail.first()).getValue(), (byte[])value2));
        head = this.csls.headSet((Cell)splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((Cell)head.first()).getValue(), (byte[])value2));
    }
}

