/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;

@InterfaceAudience.Private
public class ModifyTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(ModifyTableHandler.class);
    private final HTableDescriptor htd;

    public ModifyTableHandler(TableName tableName, HTableDescriptor htd, Server server, MasterServices masterServices) {
        super(EventType.C_M_MODIFY_TABLE, tableName, server, masterServices);
        this.htd = htd;
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        super.prepareWithTableLock();
        if (this.masterServices.getAssignmentManager().getTableStateManager().isTableState(this.htd.getTableName(), ZooKeeperProtos.Table.State.ENABLED) && this.htd.getRegionReplication() != this.getTableDescriptor().getRegionReplication()) {
            throw new IOException("REGION_REPLICATION change is not supported for enabled tables");
        }
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preModifyTableHandler(this.tableName, this.htd);
        }
        HTableDescriptor oldHtd = this.getTableDescriptor();
        this.masterServices.getTableDescriptors().add(this.htd);
        this.deleteFamilyFromFS(hris, oldHtd.getFamiliesKeys());
        this.removeReplicaColumnsIfNeeded(this.htd.getRegionReplication(), oldHtd.getRegionReplication(), this.htd.getTableName());
        if (this.htd.getRegionReplication() > 1 && oldHtd.getRegionReplication() <= 1) {
            ServerRegionReplicaUtil.setupRegionReplicaReplication(this.server.getConfiguration());
        }
        if (cpHost != null) {
            cpHost.postModifyTableHandler(this.tableName, this.htd);
        }
    }

    private void removeReplicaColumnsIfNeeded(int newReplicaCount, int oldReplicaCount, TableName table) throws IOException {
        if (newReplicaCount >= oldReplicaCount) {
            return;
        }
        HashSet<byte[]> tableRows = new HashSet<byte[]>();
        Scan scan = MetaTableAccessor.getScanForTableName((TableName)table);
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ClusterConnection connection = this.masterServices.getConnection();
        try (Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
            ResultScanner resScanner = metaTable.getScanner(scan);
            for (Result result : resScanner) {
                tableRows.add(result.getRow());
            }
            MetaTableAccessor.removeRegionReplicasFromMeta(tableRows, (int)newReplicaCount, (int)(oldReplicaCount - newReplicaCount), (Connection)this.masterServices.getConnection());
        }
    }

    private void deleteFamilyFromFS(List<HRegionInfo> hris, Set<byte[]> oldFamilies) {
        try {
            Set newFamilies = this.htd.getFamiliesKeys();
            MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
            for (byte[] familyName : oldFamilies) {
                if (newFamilies.contains(familyName)) continue;
                LOG.debug((Object)("Removing family=" + Bytes.toString((byte[])familyName) + " from table=" + this.tableName));
                for (HRegionInfo hri : hris) {
                    mfs.deleteFamilyFromFS(hri, familyName);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to remove on-disk directories for the removed families", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }
}

