/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.filter.GZIPRequestWrapper;
import org.apache.hadoop.hbase.rest.filter.GZIPResponseStream;
import org.apache.hadoop.hbase.rest.filter.GZIPResponseWrapper;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class GzipFilter
implements Filter {
    private Set<String> mimeTypes = new HashSet<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String s = filterConfig.getInitParameter("mimeTypes");
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, ",", false);
            while (tok.hasMoreTokens()) {
                this.mimeTypes.add(tok.nextToken());
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        ServletOutputStream os;
        Object request = (HttpServletRequest)req;
        Object response = (HttpServletResponse)rsp;
        String contentEncoding = request.getHeader("content-encoding");
        String acceptEncoding = request.getHeader("accept-encoding");
        String contentType = request.getHeader("content-type");
        if (contentEncoding != null && contentEncoding.toLowerCase(Locale.ROOT).indexOf("gzip") > -1) {
            request = new GZIPRequestWrapper((HttpServletRequest)request);
        }
        if (acceptEncoding != null && acceptEncoding.toLowerCase(Locale.ROOT).indexOf("gzip") > -1 || contentType != null && this.mimeTypes.contains(contentType)) {
            response = new GZIPResponseWrapper((HttpServletResponse)response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (response instanceof GZIPResponseWrapper && (os = response.getOutputStream()) instanceof GZIPResponseStream) {
            ((GZIPResponseStream)os).finish();
        }
    }
}

