/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.jmx;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestJMXJsonServlet
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestJMXJsonServlet.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestJMXJsonServlet.class);
    private static HttpServer server;
    private static URL baseUrl;

    @BeforeClass
    public static void setup() throws Exception {
        System.setProperty("test.build.webapps", "target/test-classes/webapps");
        server = TestJMXJsonServlet.createTestServer();
        server.start();
        baseUrl = TestJMXJsonServlet.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    public static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        Assert.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    public static void assertNotFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        Assert.assertFalse((String)("'" + p + "' should not match " + value), (boolean)m.find());
    }

    @Test
    public void testQuery() throws Exception {
        String result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Runtime"));
        LOG.info("/jmx?qry=java.lang:type=Runtime RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Runtime\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory"));
        LOG.info("/jmx?qry=java.lang:type=Memory RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::HeapMemoryUsage"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"ERROR\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory&callback=mycallback1"));
        LOG.info("/jmx?qry=java.lang:type=Memory&callback=mycallback RESULT: " + result);
        TestJMXJsonServlet.assertReFind("^mycallback1\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::&callback=mycallback2"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("^mycallback2\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\"ERROR\"", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::HeapMemoryUsage&callback=mycallback3"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("^mycallback3\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?excl=Hadoop:service=HBase,name=RegionServer,sub=Regions"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertNotFind("\"name\"\\s*:\\s*\"Hadoop:service=HBase,name=RegionServer,sub=Regions\"", result);
    }

    @Test
    public void testGetPattern() throws Exception {
        String result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::[a-zA-z_]*NonHeapMemoryUsage"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        TestJMXJsonServlet.assertReFind("\"NonHeapMemoryUsage\"\\s*:", result);
        TestJMXJsonServlet.assertNotFind("\"HeapMemoryUsage\"\\s*:", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::[^Non]*HeapMemoryUsage"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        TestJMXJsonServlet.assertReFind("\"HeapMemoryUsage\"\\s*:", result);
        TestJMXJsonServlet.assertNotFind("\"NonHeapHeapMemoryUsage\"\\s*:", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::[a-zA-z_]*HeapMemoryUsage,[a-zA-z_]*NonHeapMemoryUsage"));
        LOG.info("/jmx RESULT: " + result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
    }

    @Test
    public void testPatternMatching() throws Exception {
        TestJMXJsonServlet.assertReFind("[a-zA-z_]*Table1[a-zA-z_]*memStoreSize", "Namespace_default_table_Table1_metric_memStoreSize");
        TestJMXJsonServlet.assertReFind("[a-zA-z_]*memStoreSize", "Namespace_default_table_Table1_metric_memStoreSize");
    }

    @Test
    public void testDisallowedJSONPCallback() throws Exception {
        String callback = "function(){alert('bigproblems!')};foo";
        URL url = new URL(baseUrl, "/jmx?qry=java.lang:type=Memory&callback=" + URLEncoder.encode(callback, "UTF-8"));
        HttpURLConnection cnxn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)500L, (long)cnxn.getResponseCode());
    }

    @Test
    public void testUnderscoresInJSONPCallback() throws Exception {
        String callback = "my_function";
        URL url = new URL(baseUrl, "/jmx?qry=java.lang:type=Memory&callback=" + URLEncoder.encode(callback, "UTF-8"));
        HttpURLConnection cnxn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)cnxn.getResponseCode());
    }
}

