/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import java.io.File;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.util.Properties;
import javax.net.ssl.SSLException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLogLevel {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogLevel.class);
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration serverConf;
    private static Configuration clientConf;
    private static Configuration sslConf;
    private static final String logName;
    private static final Logger log;
    private static final String PRINCIPAL = "loglevel.principal";
    private static final String KEYTAB = "loglevel.keytab";
    private static MiniKdc kdc;
    private static final String LOCALHOST = "localhost";
    private static final String clientPrincipal = "client/localhost";
    private static String HTTP_PRINCIPAL;
    private static HBaseCommonTestingUtility HTU;
    private static File keyTabFile;

    @BeforeClass
    public static void setUp() throws Exception {
        serverConf = new Configuration();
        HTU = new HBaseCommonTestingUtility(serverConf);
        File keystoreDir = new File(HTU.getDataTestDir("keystore").toString());
        keystoreDir.mkdirs();
        keyTabFile = new File(HTU.getDataTestDir("keytab").toString(), "keytabfile");
        keyTabFile.getParentFile().mkdirs();
        clientConf = new Configuration();
        TestLogLevel.setupSSL(keystoreDir);
        kdc = TestLogLevel.setupMiniKdc();
        kdc.createPrincipal(keyTabFile, new String[]{clientPrincipal, HTTP_PRINCIPAL});
    }

    private static MiniKdc setupMiniKdc() throws Exception {
        boolean bindException;
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        MiniKdc kdc = null;
        File dir = null;
        int numTries = 0;
        do {
            try {
                bindException = false;
                dir = new File(HTU.getDataTestDir("kdc").toUri().getPath());
                kdc = new MiniKdc(conf, dir);
                kdc.start();
            }
            catch (BindException e) {
                FileUtils.deleteDirectory(dir);
                if (++numTries == 3) {
                    log.error((Object)("Failed setting up MiniKDC. Tried " + numTries + " times."));
                    throw e;
                }
                log.error((Object)"BindException encountered when setting up MiniKdc. Trying again.");
                bindException = true;
            }
        } while (bindException);
        return kdc;
    }

    private static void setupSSL(File base) throws Exception {
        clientConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        clientConf.set("dfs.namenode.https-address", "localhost:0");
        clientConf.set("dfs.datanode.https.address", "localhost:0");
        keystoresDir = base.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestLogLevel.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, serverConf, false);
        sslConf = TestLogLevel.getSslConfig(serverConf);
    }

    private static Configuration getSslConfig(Configuration conf) {
        Configuration sslConf = new Configuration(false);
        String sslServerConfFile = conf.get("hadoop.ssl.server.conf");
        String sslClientConfFile = conf.get("hadoop.ssl.client.conf");
        sslConf.addResource(sslServerConfFile);
        sslConf.addResource(sslClientConfFile);
        sslConf.set("hadoop.ssl.server.conf", sslServerConfFile);
        sslConf.set("hadoop.ssl.client.conf", sslClientConfFile);
        return sslConf;
    }

    @AfterClass
    public static void tearDown() {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)new File(HTU.getDataTestDir().toString()));
    }

    @Test
    public void testCommandOptions() throws Exception {
        String className = this.getClass().getName();
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-foo"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[0]));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG", "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-setlevel", "foo.bar:8080", className}));
    }

    private boolean validateCommand(String[] args) {
        LogLevel.CLI cli = new LogLevel.CLI(clientConf);
        try {
            cli.parseArguments(args);
        }
        catch (HadoopIllegalArgumentException e) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private HttpServer createServer(String protocol, boolean isSpnego) throws Exception {
        HttpServer.Builder builder = new HttpServer.Builder().setName("..").addEndpoint(new URI(protocol + "://localhost:0")).setFindPort(true).setConf(serverConf);
        if (isSpnego) {
            builder.setSecurityEnabled(true).setUsernameConfKey(PRINCIPAL).setKeytabConfKey(KEYTAB).setACL(new AccessControlList("client"));
        }
        if (protocol.equals("https")) {
            builder = builder.keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
        }
        HttpServer server = builder.build();
        server.start();
        return server;
    }

    private void testDynamicLogLevel(String bindProtocol, String connectProtocol, boolean isSpnego) throws Exception {
        this.testDynamicLogLevel(bindProtocol, connectProtocol, isSpnego, Level.DEBUG.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDynamicLogLevel(String bindProtocol, String connectProtocol, boolean isSpnego, String newLevel) throws Exception {
        if (!LogLevel.isValidProtocol((String)bindProtocol)) {
            throw new Exception("Invalid server protocol " + bindProtocol);
        }
        if (!LogLevel.isValidProtocol((String)connectProtocol)) {
            throw new Exception("Invalid client protocol " + connectProtocol);
        }
        Level oldLevel = log.getEffectiveLevel();
        Assert.assertNotEquals((String)"Get default Log Level which shouldn't be ERROR.", (Object)Level.ERROR, (Object)oldLevel);
        if (isSpnego) {
            serverConf.set(PRINCIPAL, HTTP_PRINCIPAL);
            serverConf.set(KEYTAB, keyTabFile.getAbsolutePath());
            serverConf.set("hadoop.security.authentication", "kerberos");
            serverConf.setBoolean("hadoop.security.authorization", true);
            UserGroupInformation.setConfiguration((Configuration)serverConf);
        } else {
            serverConf.set("hadoop.security.authentication", "simple");
            serverConf.setBoolean("hadoop.security.authorization", false);
            UserGroupInformation.setConfiguration((Configuration)serverConf);
        }
        HttpServer server = this.createServer(bindProtocol, isSpnego);
        String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
        String keytabFilePath = keyTabFile.getAbsolutePath();
        UserGroupInformation clientUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)clientPrincipal, (String)keytabFilePath);
        try {
            clientUGI.doAs(() -> {
                this.getLevel(connectProtocol, authority);
                this.setLevel(connectProtocol, authority, newLevel);
                return null;
            });
        }
        finally {
            clientUGI.logoutUserFromKeytab();
            server.stop();
        }
        GenericTestUtils.setLogLevel((Logger)log, (Level)oldLevel);
    }

    private void getLevel(String protocol, String authority) throws Exception {
        String[] getLevelArgs = new String[]{"-getlevel", authority, logName, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(protocol.equalsIgnoreCase("https") ? sslConf : clientConf);
        cli.run(getLevelArgs);
    }

    private void setLevel(String protocol, String authority, String newLevel) throws Exception {
        String[] setLevelArgs = new String[]{"-setlevel", authority, logName, newLevel, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(protocol.equalsIgnoreCase("https") ? sslConf : clientConf);
        cli.run(setLevelArgs);
        Assert.assertEquals((String)"new level not equal to expected: ", (Object)newLevel.toUpperCase(), (Object)log.getEffectiveLevel().toString());
    }

    @Test
    public void testInfoLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", true, "INFO");
    }

    @Test
    public void testErrorLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", true, "ERROR");
    }

    @Test
    public void testLogLevelByHttp() throws Exception {
        this.testDynamicLogLevel("http", "http", false);
        try {
            this.testDynamicLogLevel("http", "https", false);
            Assert.fail((String)"An HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            TestLogLevel.exceptionShouldContains("Unrecognized SSL message", e);
        }
    }

    @Test
    public void testLogLevelByHttpWithSpnego() throws Exception {
        this.testDynamicLogLevel("http", "http", true);
        try {
            this.testDynamicLogLevel("http", "https", true);
            Assert.fail((String)"An HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            TestLogLevel.exceptionShouldContains("Unrecognized SSL message", e);
        }
    }

    @Test
    public void testLogLevelByHttps() throws Exception {
        this.testDynamicLogLevel("https", "https", false);
        try {
            this.testDynamicLogLevel("https", "http", false);
            Assert.fail((String)"An HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            TestLogLevel.exceptionShouldContains("Unexpected end of file from server", e);
        }
    }

    @Test
    public void testLogLevelByHttpsWithSpnego() throws Exception {
        this.testDynamicLogLevel("https", "https", true);
        try {
            this.testDynamicLogLevel("https", "http", true);
            Assert.fail((String)"An HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            TestLogLevel.exceptionShouldContains("Unexpected end of file from server", e);
        }
    }

    private static void exceptionShouldContains(String substr, Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            String msg = t.toString();
            if (msg == null || !msg.toLowerCase().contains(substr.toLowerCase())) continue;
            return;
        }
        throw new AssertionError("Expected to find '" + substr + "' but got unexpected exception:" + StringUtils.stringifyException((Throwable)throwable), throwable);
    }

    static {
        logName = TestLogLevel.class.getName();
        log = LogManager.getLogger((String)logName);
        HTTP_PRINCIPAL = "HTTP/localhost";
    }
}

