/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xerial;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.HFileTestBase;
import org.apache.hadoop.hbase.io.compress.xerial.SnappyCodec;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileCompressionSnappy
extends HFileTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileCompressionSnappy.class);
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Assume.assumeTrue((boolean)SnappyCodec.isLoaded());
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.io.compress.snappy.codec", SnappyCodec.class.getCanonicalName());
        Compression.Algorithm.SNAPPY.reload(conf);
        HFileTestBase.setUpBeforeClass();
    }

    @Test
    public void test() throws Exception {
        Path path = new Path(TEST_UTIL.getDataTestDir(), HBaseTestingUtility.getRandomUUID().toString() + ".hfile");
        this.doTest(conf, path, Compression.Algorithm.SNAPPY);
    }
}

