/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xerial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.xerial.SnappyCompressor;
import org.apache.hadoop.hbase.io.compress.xerial.SnappyDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.xerial.snappy.Snappy;

@InterfaceAudience.Private
public class SnappyCodec
implements Configurable,
CompressionCodec {
    public static final String SNAPPY_BUFFER_SIZE_KEY = "hbase.io.compress.snappy.buffersize";
    private Configuration conf = new Configuration();
    private int bufferSize = SnappyCodec.getBufferSize(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = SnappyCodec.getBufferSize(conf);
    }

    public Compressor createCompressor() {
        return new SnappyCompressor(this.bufferSize);
    }

    public Decompressor createDecompressor() {
        return new SnappyDecompressor(this.bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, Snappy.maxCompressedLength((int)this.bufferSize) - this.bufferSize);
    }

    public Class<? extends Compressor> getCompressorType() {
        return SnappyCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return SnappyDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".snappy";
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(SNAPPY_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.snappy.buffersize", 262144));
    }
}

