/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCoprocessorClassLoader {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorClassLoader.class);
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();

    @Test
    public void testCleanupOldJars() throws Exception {
        String className = "TestCleanupOldJars";
        String folder = TEST_UTIL.getDataTestDir().toString();
        File jarFile = ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(conf));
        File tmpJarFile = new File(jarFile.getParent(), "/tmp/" + className + ".test.jar");
        if (tmpJarFile.exists()) {
            tmpJarFile.delete();
        }
        Assert.assertFalse((String)"tmp jar file should not exist", (boolean)tmpJarFile.exists());
        IOUtils.copyBytes((InputStream)new FileInputStream(jarFile), (OutputStream)new FileOutputStream(tmpJarFile), (Configuration)conf, (boolean)true);
        Assert.assertTrue((String)"tmp jar file should be created", (boolean)tmpJarFile.exists());
        Path path = new Path(jarFile.getAbsolutePath());
        ClassLoader parent = TestCoprocessorClassLoader.class.getClassLoader();
        CoprocessorClassLoader.parentDirLockSet.clear();
        CoprocessorClassLoader classLoader = CoprocessorClassLoader.getClassLoader((Path)path, (ClassLoader)parent, (String)"111", (Configuration)conf);
        Assert.assertNotNull((String)"Classloader should be created", (Object)classLoader);
        Assert.assertFalse((String)"tmp jar file should be removed", (boolean)tmpJarFile.exists());
    }

    @Test
    public void testLibJarName() throws Exception {
        this.checkingLibJarName("TestLibJarName.jar", "/lib/");
    }

    @Test
    public void testRelativeLibJarName() throws Exception {
        this.checkingLibJarName("TestRelativeLibJarName.jar", "lib/");
    }

    private void checkingLibJarName(String jarName, String libPrefix) throws Exception {
        File[] files;
        File tmpFolder = new File(ClassLoaderTestHelper.localDirPath(conf), "tmp");
        if (tmpFolder.exists() && (files = tmpFolder.listFiles()) != null) {
            for (File f : files) {
                f.delete();
            }
        }
        String className = "CheckingLibJarName";
        String folder = TEST_UTIL.getDataTestDir().toString();
        File innerJarFile = ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(conf));
        File targetJarFile = new File(innerJarFile.getParent(), jarName);
        ClassLoaderTestHelper.addJarFilesToJar(targetJarFile, libPrefix, innerJarFile);
        Path path = new Path(targetJarFile.getAbsolutePath());
        ClassLoader parent = TestCoprocessorClassLoader.class.getClassLoader();
        CoprocessorClassLoader classLoader = CoprocessorClassLoader.getClassLoader((Path)path, (ClassLoader)parent, (String)"112", (Configuration)conf);
        Assert.assertNotNull((String)"Classloader should be created", (Object)classLoader);
        String fileToLookFor = "." + className + ".jar";
        String[] files2 = tmpFolder.list();
        if (files2 != null) {
            for (String f : files2) {
                if (!f.endsWith(fileToLookFor) || !f.contains(jarName)) continue;
                return;
            }
        }
        Assert.fail((String)"Could not find the expected lib jar file");
    }

    @Test
    public void testDirectoryAndWildcard() throws Exception {
        String testClassName = "TestClass";
        String dataTestDir = TEST_UTIL.getDataTestDir().toString();
        System.out.println(dataTestDir);
        String localDirContainingJar = ClassLoaderTestHelper.localDirPath(conf);
        ClassLoaderTestHelper.buildJar(dataTestDir, testClassName, null, localDirContainingJar);
        ClassLoader parent = TestCoprocessorClassLoader.class.getClassLoader();
        CoprocessorClassLoader.parentDirLockSet.clear();
        CoprocessorClassLoader coprocessorClassLoader = null;
        Path testPath = null;
        testPath = new Path(localDirContainingJar);
        coprocessorClassLoader = CoprocessorClassLoader.getClassLoader((Path)testPath, (ClassLoader)parent, (String)"113_1", (Configuration)conf);
        this.verifyCoprocessorClassLoader(coprocessorClassLoader, testClassName);
        testPath = new Path(localDirContainingJar, "*.jar");
        coprocessorClassLoader = CoprocessorClassLoader.getClassLoader((Path)testPath, (ClassLoader)parent, (String)"113_2", (Configuration)conf);
        this.verifyCoprocessorClassLoader(coprocessorClassLoader, testClassName);
        testPath = new Path(localDirContainingJar, "*.j*");
        coprocessorClassLoader = CoprocessorClassLoader.getClassLoader((Path)testPath, (ClassLoader)parent, (String)"113_3", (Configuration)conf);
        this.verifyCoprocessorClassLoader(coprocessorClassLoader, testClassName);
    }

    private void verifyCoprocessorClassLoader(CoprocessorClassLoader coprocessorClassLoader, String className) throws ClassNotFoundException {
        Assert.assertNotNull((String)"Classloader should be created and not null", (Object)coprocessorClassLoader);
        Assert.assertEquals((Object)className, (Object)coprocessorClassLoader.loadClass(className).getName());
    }

    static {
        TEST_UTIL.getDataTestDir();
    }
}

