/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCellUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellUtil.class);

    @Test
    public void testCreateCellScannerOverflow() throws IOException {
        this.consume(this.doCreateCellScanner(1, 1), 1);
        this.consume(this.doCreateCellScanner(3, 0), 0);
        this.consume(this.doCreateCellScanner(3, 3), 9);
        this.consume(this.doCreateCellScanner(0, 1), 0);
        int hundredK = 100000;
        this.consume(this.doCreateCellScanner(100000, 0), 0);
        this.consume(this.doCreateCellArray(1), 1);
        this.consume(this.doCreateCellArray(0), 0);
        this.consume(this.doCreateCellArray(3), 3);
        ArrayList<TestCellScannable> cells = new ArrayList<TestCellScannable>(100000);
        for (int i = 0; i < 100000; ++i) {
            cells.add(new TestCellScannable(1));
        }
        this.consume(CellUtil.createCellScanner(cells), 100000);
        TreeMap m = new TreeMap(Bytes.BYTES_COMPARATOR);
        ArrayList<TestCell> cellArray = new ArrayList<TestCell>(100000);
        for (int i = 0; i < 100000; ++i) {
            cellArray.add(new TestCell(i));
        }
        m.put(new byte[]{102}, cellArray);
        this.consume(CellUtil.createCellScanner(m), 100000);
    }

    private CellScanner doCreateCellArray(int itemsPerList) {
        Cell[] cells = new Cell[itemsPerList];
        for (int i = 0; i < itemsPerList; ++i) {
            cells[i] = new TestCell(i);
        }
        return CellUtil.createCellScanner((Cell[])cells);
    }

    private CellScanner doCreateCellScanner(int listsCount, final int itemsPerList) throws IOException {
        ArrayList<1> cells = new ArrayList<1>(listsCount);
        for (int i = 0; i < listsCount; ++i) {
            CellScannable cs = new CellScannable(){

                public CellScanner cellScanner() {
                    return new TestCellScanner(itemsPerList);
                }
            };
            cells.add(cs);
        }
        return CellUtil.createCellScanner(cells);
    }

    private void consume(CellScanner scanner, int expected) throws IOException {
        int count = 0;
        while (scanner.advance()) {
            ++count;
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        byte[] d = Bytes.toBytes((String)"d");
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])d));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])b));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])empty));
        Assert.assertTrue((boolean)PrivateCellUtil.overlappingKeys((byte[])empty, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])empty));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])d, (byte[])empty));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])c, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])d, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])b));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])a));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)PrivateCellUtil.overlappingKeys((byte[])empty, (byte[])a, (byte[])b, (byte[])c));
    }

    @Test
    public void testFindCommonPrefixInFlatKey() {
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"r1"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), null);
        Assert.assertEquals((long)kv1.getKeyLength(), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv1, (Cell)kv1, (boolean)true, (boolean)true));
        Assert.assertEquals((long)kv1.getKeyLength(), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv1, (Cell)kv1, (boolean)false, (boolean)true));
        Assert.assertEquals((long)(kv1.getKeyLength() - 9), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv1, (Cell)kv1, (boolean)true, (boolean)false));
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"r12"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), null);
        Assert.assertEquals((long)1L, (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv1, (Cell)kv2, (boolean)true, (boolean)true));
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"r14"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), null);
        Assert.assertEquals((long)(2 + Bytes.toBytes((String)"r1").length), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv2, (Cell)kv3, (boolean)true, (boolean)true));
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"r14"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"q1"), null);
        Assert.assertEquals((long)(2 + kv3.getRowLength() + 1 + Bytes.toBytes((String)"f").length), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv3, (Cell)kv4, (boolean)false, (boolean)true));
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"r14"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"q123"), null);
        Assert.assertEquals((long)(2 + kv3.getRowLength() + 1 + kv4.getFamilyLength() + kv4.getQualifierLength()), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv4, (Cell)kv5, (boolean)true, (boolean)true));
        KeyValue kv6 = new KeyValue(Bytes.toBytes((String)"rk"), 1234L);
        KeyValue kv7 = new KeyValue(Bytes.toBytes((String)"rk"), 1235L);
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength() + 7), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv6, (Cell)kv7, (boolean)true, (boolean)true));
        KeyValue kv8 = new KeyValue(Bytes.toBytes((String)"rk"), 1234L, KeyValue.Type.Delete);
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength() + 8), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv6, (Cell)kv8, (boolean)true, (boolean)true));
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength()), (long)PrivateCellUtil.findCommonPrefixInFlatKey((Cell)kv6, (Cell)kv8, (boolean)true, (boolean)false));
    }

    @Test
    public void testToString() {
        byte[] row = Bytes.toBytes((String)"row");
        long ts = 123L;
        KeyValue kv = new KeyValue(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, ts, KeyValue.Type.Minimum, HConstants.EMPTY_BYTE_ARRAY);
        Cell cell = CellUtil.createCell((byte[])row, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])HConstants.EMPTY_BYTE_ARRAY, (long)ts, (byte)KeyValue.Type.Minimum.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        String cellToString = CellUtil.getCellKeyAsString((Cell)cell);
        Assert.assertEquals((Object)kv.toString(), (Object)cellToString);
        byte[] f = new byte[]{102};
        byte[] q = new byte[]{113};
        kv = new KeyValue(row, f, q, ts, KeyValue.Type.Minimum, HConstants.EMPTY_BYTE_ARRAY);
        cell = CellUtil.createCell((byte[])row, (byte[])f, (byte[])q, (long)ts, (byte)KeyValue.Type.Minimum.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        cellToString = CellUtil.getCellKeyAsString((Cell)cell);
        Assert.assertEquals((Object)kv.toString(), (Object)cellToString);
    }

    @Test
    public void testToString1() {
        String row = "test.row";
        String family = "test.family";
        String qualifier = "test.qualifier";
        long timestamp = 42L;
        KeyValue.Type type = KeyValue.Type.Put;
        String value = "test.value";
        long seqId = 1042L;
        Cell cell = CellUtil.createCell((byte[])Bytes.toBytes((String)row), (byte[])Bytes.toBytes((String)family), (byte[])Bytes.toBytes((String)qualifier), (long)timestamp, (byte)type.getCode(), (byte[])Bytes.toBytes((String)value), (long)seqId);
        String nonVerbose = CellUtil.toString((Cell)cell, (boolean)false);
        String verbose = CellUtil.toString((Cell)cell, (boolean)true);
        System.out.println("nonVerbose=" + nonVerbose);
        System.out.println("verbose=" + verbose);
        Assert.assertEquals((Object)String.format("%s/%s:%s/%d/%s/vlen=%s/seqid=%s", row, family, qualifier, timestamp, type.toString(), Bytes.toBytes((String)value).length, seqId), (Object)nonVerbose);
        Assert.assertEquals((Object)String.format("%s/%s:%s/%d/%s/vlen=%s/seqid=%s/%s", row, family, qualifier, timestamp, type.toString(), Bytes.toBytes((String)value).length, seqId, value), (Object)verbose);
    }

    @Test
    public void testCloneCellFieldsFromByteBufferedCell() {
        byte[] r = Bytes.toBytes((String)"row1");
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q = Bytes.toBytes((String)"qual1");
        byte[] v = Bytes.toBytes((String)"val1");
        byte[] tags = Bytes.toBytes((String)"tag1");
        KeyValue kv = new KeyValue(r, f, q, 0, q.length, 1234L, KeyValue.Type.Put, v, 0, v.length, tags);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        byte[] rDest = CellUtil.cloneRow((Cell)bbCell);
        Assert.assertTrue((boolean)Bytes.equals((byte[])r, (byte[])rDest));
        byte[] fDest = CellUtil.cloneFamily((Cell)bbCell);
        Assert.assertTrue((boolean)Bytes.equals((byte[])f, (byte[])fDest));
        byte[] qDest = CellUtil.cloneQualifier((Cell)bbCell);
        Assert.assertTrue((boolean)Bytes.equals((byte[])q, (byte[])qDest));
        byte[] vDest = CellUtil.cloneValue((Cell)bbCell);
        Assert.assertTrue((boolean)Bytes.equals((byte[])v, (byte[])vDest));
        byte[] tDest = new byte[tags.length];
        PrivateCellUtil.copyTagsTo((Cell)bbCell, (byte[])tDest, (int)0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])tags, (byte[])tDest));
    }

    @Test
    public void testMatchingCellFieldsFromByteBufferedCell() {
        byte[] r = Bytes.toBytes((String)"row1");
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q1 = Bytes.toBytes((String)"qual1");
        byte[] q2 = Bytes.toBytes((String)"qual2");
        byte[] v = Bytes.toBytes((String)"val1");
        byte[] tags = Bytes.toBytes((String)"tag1");
        KeyValue kv = new KeyValue(r, f, q1, 0, q1.length, 1234L, KeyValue.Type.Put, v, 0, v.length, tags);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell1 = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        kv = new KeyValue(r, f, q2, 0, q2.length, 1234L, KeyValue.Type.Put, v, 0, v.length, tags);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell2 = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)kv, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)bbCell1, (byte[])r));
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)kv, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)bbCell1, (byte[])f));
        Assert.assertFalse((boolean)CellUtil.matchingQualifier((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)kv, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)bbCell1, (byte[])q1));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)bbCell2, (byte[])q2));
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)bbCell1, (byte[])v));
        Assert.assertFalse((boolean)CellUtil.matchingColumn((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)kv, (Cell)bbCell2));
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)bbCell1, (byte[])f, (byte[])q1));
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)bbCell2, (byte[])f, (byte[])q2));
    }

    @Test
    public void testCellFieldsAsPrimitiveTypesFromByteBufferedCell() {
        int ri = 123;
        byte[] r = Bytes.toBytes((int)ri);
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q = Bytes.toBytes((String)"qual1");
        long vl = 10981L;
        byte[] v = Bytes.toBytes((long)vl);
        KeyValue kv = new KeyValue(r, f, q, v);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)ri, (long)PrivateCellUtil.getRowAsInt((Cell)bbCell));
        Assert.assertEquals((long)vl, (long)PrivateCellUtil.getValueAsLong((Cell)bbCell));
        double vd = 3005.5;
        v = Bytes.toBytes((double)vd);
        kv = new KeyValue(r, f, q, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((double)vd, (double)PrivateCellUtil.getValueAsDouble((Cell)bbCell), (double)0.0);
        BigDecimal bd = new BigDecimal(9999);
        v = Bytes.toBytes((BigDecimal)bd);
        kv = new KeyValue(r, f, q, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((Object)bd, (Object)PrivateCellUtil.getValueAsBigDecimal((Cell)bbCell));
    }

    @Test
    public void testWriteCell() throws IOException {
        byte[] r = Bytes.toBytes((String)"row1");
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q1 = Bytes.toBytes((String)"qual1");
        byte[] q2 = Bytes.toBytes((String)"qual2");
        byte[] v = Bytes.toBytes((String)"val1");
        byte[] tags = Bytes.toBytes((String)"tag1");
        KeyValue kv = new KeyValue(r, f, q1, 0, q1.length, 1234L, KeyValue.Type.Put, v, 0, v.length, tags);
        NonExtendedCell nonExtCell = new NonExtendedCell(kv);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int writeCell = PrivateCellUtil.writeCell((Cell)nonExtCell, (OutputStream)os, (boolean)true);
        byte[] byteArray = os.toByteArray();
        KeyValue res = new KeyValue(byteArray);
        Assert.assertTrue((boolean)CellUtil.equals((Cell)kv, (Cell)res));
    }

    @Test
    public void testGetType() throws IOException {
        Cell c = (Cell)Mockito.mock(Cell.class);
        Mockito.when((Object)c.getType()).thenCallRealMethod();
        for (Cell.Type type : Cell.Type.values()) {
            Mockito.when((Object)c.getTypeByte()).thenReturn((Object)type.getCode());
            Assert.assertEquals((Object)type, (Object)c.getType());
        }
        try {
            Mockito.when((Object)c.getTypeByte()).thenReturn((Object)KeyValue.Type.Maximum.getCode());
            c.getType();
            Assert.fail((String)"The code of Maximum can't be handled by Cell.Type");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            Mockito.when((Object)c.getTypeByte()).thenReturn((Object)KeyValue.Type.Minimum.getCode());
            c.getType();
            Assert.fail((String)"The code of Maximum can't be handled by Cell.Type");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static class NonExtendedCell
    implements Cell {
        private KeyValue kv;

        public NonExtendedCell(KeyValue kv) {
            this.kv = kv;
        }

        public byte[] getRowArray() {
            return this.kv.getRowArray();
        }

        public int getRowOffset() {
            return this.kv.getRowOffset();
        }

        public short getRowLength() {
            return this.kv.getRowLength();
        }

        public byte[] getFamilyArray() {
            return this.kv.getFamilyArray();
        }

        public int getFamilyOffset() {
            return this.kv.getFamilyOffset();
        }

        public byte getFamilyLength() {
            return this.kv.getFamilyLength();
        }

        public byte[] getQualifierArray() {
            return this.kv.getQualifierArray();
        }

        public int getQualifierOffset() {
            return this.kv.getQualifierOffset();
        }

        public int getQualifierLength() {
            return this.kv.getQualifierLength();
        }

        public long getTimestamp() {
            return this.kv.getTimestamp();
        }

        public byte getTypeByte() {
            return this.kv.getTypeByte();
        }

        public long getSequenceId() {
            return this.kv.getSequenceId();
        }

        public byte[] getValueArray() {
            return this.kv.getValueArray();
        }

        public int getValueOffset() {
            return this.kv.getValueOffset();
        }

        public int getValueLength() {
            return this.kv.getValueLength();
        }

        public byte[] getTagsArray() {
            return this.kv.getTagsArray();
        }

        public int getTagsOffset() {
            return this.kv.getTagsOffset();
        }

        public int getTagsLength() {
            return this.kv.getTagsLength();
        }
    }

    private static class TestCell
    implements Cell {
        private final byte[] row;

        TestCell(int i) {
            this.row = Bytes.toBytes((int)i);
        }

        public byte[] getRowArray() {
            return this.row;
        }

        public int getRowOffset() {
            return 0;
        }

        public short getRowLength() {
            return (short)this.row.length;
        }

        public byte[] getFamilyArray() {
            return null;
        }

        public int getFamilyOffset() {
            return 0;
        }

        public byte getFamilyLength() {
            return 0;
        }

        public byte[] getQualifierArray() {
            return null;
        }

        public int getQualifierOffset() {
            return 0;
        }

        public int getQualifierLength() {
            return 0;
        }

        public long getTimestamp() {
            return 0L;
        }

        public byte getTypeByte() {
            return 0;
        }

        public byte[] getValueArray() {
            return null;
        }

        public int getValueOffset() {
            return 0;
        }

        public int getValueLength() {
            return 0;
        }

        public byte[] getTagsArray() {
            return null;
        }

        public int getTagsOffset() {
            return 0;
        }

        public long getSequenceId() {
            return 0L;
        }

        public int getTagsLength() {
            return 0;
        }
    }

    private static class TestCellScanner
    implements CellScanner {
        private int count = 0;
        private Cell current = null;
        private final int cellsCount;

        TestCellScanner(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        public Cell current() {
            return this.current;
        }

        public boolean advance() throws IOException {
            if (this.count < this.cellsCount) {
                this.current = new TestCell(this.count);
                ++this.count;
                return true;
            }
            return false;
        }
    }

    private static class TestCellScannable
    implements CellScannable {
        private final int cellsCount;

        TestCellScannable(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        public CellScanner cellScanner() {
            return new TestCellScanner(this.cellsCount);
        }
    }
}

