/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.hadoop.hbase.util.WeakObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestWeakObjectPool {
    ObjectPool<String, Object> pool;

    @Before
    public void setUp() {
        this.pool = new WeakObjectPool((ObjectPool.ObjectFactory)new ObjectPool.ObjectFactory<String, Object>(){

            public Object createObject(String key) {
                return new Object();
            }
        });
    }

    @Test
    public void testKeys() {
        Object obj1 = this.pool.get((Object)"a");
        Object obj2 = this.pool.get((Object)new String("a"));
        Assert.assertSame((Object)obj1, (Object)obj2);
        Object obj3 = this.pool.get((Object)"b");
        Assert.assertNotSame((Object)obj1, (Object)obj3);
    }

    @Test
    public void testWeakReference() throws Exception {
        Object obj1 = this.pool.get((Object)"a");
        int hash1 = System.identityHashCode(obj1);
        System.gc();
        System.gc();
        System.gc();
        Thread.sleep(10L);
        this.pool.purge();
        Assert.assertEquals((long)1L, (long)this.pool.size());
        Object obj2 = this.pool.get((Object)"a");
        Assert.assertSame((Object)obj1, (Object)obj2);
        obj1 = null;
        obj2 = null;
        System.gc();
        System.gc();
        System.gc();
        Thread.sleep(10L);
        this.pool.purge();
        Assert.assertEquals((long)0L, (long)this.pool.size());
        Object obj3 = this.pool.get((Object)"a");
        Assert.assertNotEquals((long)hash1, (long)System.identityHashCode(obj3));
    }

    @Test(timeout=1000L)
    public void testCongestion() throws Exception {
        int THREAD_COUNT = 100;
        final AtomicBoolean assertionFailed = new AtomicBoolean();
        final AtomicReference expectedObjRef = new AtomicReference();
        final CountDownLatch prepareLatch = new CountDownLatch(100);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            new Thread(){

                @Override
                public void run() {
                    prepareLatch.countDown();
                    try {
                        startLatch.await();
                        Object obj = TestWeakObjectPool.this.pool.get((Object)"a");
                        if (!expectedObjRef.compareAndSet(null, obj) && expectedObjRef.get() != obj) {
                            assertionFailed.set(true);
                        }
                    }
                    catch (Exception e) {
                        assertionFailed.set(true);
                    }
                    finally {
                        endLatch.countDown();
                    }
                }
            }.start();
        }
        prepareLatch.await();
        startLatch.countDown();
        endLatch.await();
        if (assertionFailed.get()) {
            Assert.fail();
        }
    }
}

