/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class StreamUtils {
    public static void writeRawVInt32(OutputStream output, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                output.write(value);
                return;
            }
            output.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int readRawVarint32(InputStream input) throws IOException {
        byte tmp = (byte)input.read();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = (byte)input.read();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = (byte)input.read();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = (byte)input.read();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = (byte)input.read();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (input.read() < 0) continue;
                            return result;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result;
    }

    public static int readRawVarint32(ByteBuffer input) throws IOException {
        byte tmp = input.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = input.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = input.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = input.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = input.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (input.get() < 0) continue;
                            return result;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result;
    }

    public static Pair<Integer, Integer> readRawVarint32(byte[] input, int offset) throws IOException {
        byte tmp;
        int newOffset = offset;
        if ((tmp = input[newOffset++]) >= 0) {
            return new Pair<Integer, Integer>(Integer.valueOf(tmp), newOffset - offset);
        }
        int result = tmp & 0x7F;
        if ((tmp = input[newOffset++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = input[newOffset++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = input[newOffset++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = input[newOffset++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if ((tmp = input[newOffset++]) < 0) continue;
                            return new Pair<Integer, Integer>(result, newOffset - offset);
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return new Pair<Integer, Integer>(result, newOffset - offset);
    }

    public static short toShort(byte hi, byte lo) {
        short s = (short)((hi & 0xFF) << 8 | lo & 0xFF);
        Preconditions.checkArgument((s >= 0 ? 1 : 0) != 0);
        return s;
    }

    public static void writeShort(OutputStream out, short v) throws IOException {
        Preconditions.checkArgument((v >= 0 ? 1 : 0) != 0);
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write((byte)(0xFF & v >> 24));
        out.write((byte)(0xFF & v >> 16));
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((byte)(0xFFL & v >> 56));
        out.write((byte)(0xFFL & v >> 48));
        out.write((byte)(0xFFL & v >> 40));
        out.write((byte)(0xFFL & v >> 32));
        out.write((byte)(0xFFL & v >> 24));
        out.write((byte)(0xFFL & v >> 16));
        out.write((byte)(0xFFL & v >> 8));
        out.write((byte)(0xFFL & v));
    }

    public static long readLong(InputStream in) throws IOException {
        long result = 0L;
        for (int shift = 56; shift >= 0; shift -= 8) {
            long x = in.read();
            if (x < 0L) {
                throw new IOException("EOF");
            }
            result |= x << shift;
        }
        return result;
    }
}

