/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience.Public;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability.Unstable;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.util.Records;

/**
 * <p>
 * Mapping of Attribute Value to a Node.
 * </p>
 */
@Public
@Unstable
public abstract class NodeToAttributeValue {
  public static NodeToAttributeValue newInstance(String hostname,
      String attributeValue) {
    NodeToAttributeValue nodeToAttributeValue =
        Records.newRecord(NodeToAttributeValue.class);
    nodeToAttributeValue.setAttributeValue(attributeValue);
    nodeToAttributeValue.setHostname(hostname);
    return nodeToAttributeValue;
  }

  @Public
  @Unstable
  public abstract String getAttributeValue();

  @Public
  @Unstable
  public abstract void setAttributeValue(String attributeValue);

  @Public
  @Unstable
  public abstract String getHostname();

  @Public
  @Unstable
  public abstract void setHostname(String hostname);
}
