/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsReleaseType;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrailsVersion
implements Comparable<GrailsVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)[.](\\d+)[.](\\d+)-?(.*)$");
    private static final Pattern RC = Pattern.compile("^RC(\\d+)$");
    private static final Pattern MILESTONE = Pattern.compile("^M(\\d+)$");
    private static final Pattern SNAPSHOT = Pattern.compile("^SNAPSHOT$");
    public final String version;
    public final int major;
    public final int minor;
    public final int patch;
    public final GrailsReleaseType releaseType;
    public final Integer candidate;

    GrailsVersion(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Grails Version format: " + version);
        }
        if (matcher.groupCount() != 4) {
            throw new IllegalArgumentException("Invalid Grails Version format: " + version);
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = Integer.parseInt(matcher.group(2));
        this.patch = Integer.parseInt(matcher.group(3));
        String candidateString = matcher.group(4);
        if (candidateString.isEmpty()) {
            this.releaseType = GrailsReleaseType.RELEASE;
            this.candidate = null;
        } else {
            Matcher m = RC.matcher(candidateString);
            if (m.matches()) {
                this.releaseType = GrailsReleaseType.RC;
                this.candidate = Integer.parseInt(m.group(1));
            } else {
                m = MILESTONE.matcher(candidateString);
                if (m.matches()) {
                    this.releaseType = GrailsReleaseType.MILESTONE;
                    this.candidate = Integer.parseInt(m.group(1));
                } else {
                    m = SNAPSHOT.matcher(candidateString);
                    if (m.matches()) {
                        this.releaseType = GrailsReleaseType.SNAPSHOT;
                        this.candidate = null;
                    } else {
                        throw new IllegalArgumentException("Invalid Candidate Version: " + candidateString);
                    }
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrailsVersion that = (GrailsVersion)o;
        return Objects.equals((Object)this.releaseType, (Object)that.releaseType) && Objects.equals(this.major, that.major) && Objects.equals(this.minor, that.minor) && Objects.equals(this.patch, that.patch) && Objects.equals(this.candidate, that.candidate);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(GrailsVersion o) {
        if (o == null) {
            return 1;
        }
        if (o.equals(this)) {
            return 0;
        }
        if (this.releaseType != o.releaseType) {
            return o.releaseType.ordinal() - this.releaseType.ordinal();
        }
        int majorCompare = Integer.compare(this.major, o.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Integer.compare(this.minor, o.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = Integer.compare(this.patch, o.patch);
        if (patchCompare != 0) {
            return patchCompare;
        }
        if (this.candidate == null) {
            return 0;
        }
        return Integer.compare(this.candidate, o.candidate);
    }

    public String toString() {
        return this.version;
    }
}

