/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.grails.cli.compiler.AstUtils;
import org.grails.cli.compiler.CompilerAutoConfiguration;
import org.grails.cli.compiler.DependencyCustomizer;

public class SpringIntegrationCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableIntegration") || AstUtils.hasAtLeastOneAnnotation(classNode, "MessageEndpoint");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("org.springframework.integration.config.EnableIntegration").add("spring-boot-starter-integration");
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"org.springframework.messaging.Message", "org.springframework.messaging.MessageChannel", "org.springframework.messaging.PollableChannel", "org.springframework.messaging.SubscribableChannel", "org.springframework.messaging.MessageHeaders", "org.springframework.integration.support.MessageBuilder", "org.springframework.integration.channel.DirectChannel", "org.springframework.integration.channel.QueueChannel", "org.springframework.integration.channel.ExecutorChannel", "org.springframework.integration.core.MessagingTemplate", "org.springframework.integration.config.EnableIntegration"});
        imports.addStarImports(new String[]{"org.springframework.integration.annotation"});
    }
}

