/*
 * Decompiled with CFR 0.152.
 */
package org.apache.grails.web.layout;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.factory.DefaultFactory;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.compatability.PageParser2ContentProcessor;
import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.grails.web.layout.EmbeddedGrailsLayoutViewResolver;
import org.apache.grails.web.layout.FactoryHolder;
import org.apache.grails.web.layout.GrailsLayoutView;
import org.apache.grails.web.layout.GroovyPageLayoutFinder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class GrailsLayoutViewResolver
extends EmbeddedGrailsLayoutViewResolver
implements GrailsApplicationAware,
DisposableBean,
Ordered,
ApplicationListener<ContextRefreshedEvent> {
    private static final String FACTORY_SERVLET_CONTEXT_ATTRIBUTE = "grails.layout.factory";
    private ContentProcessor contentProcessor;
    protected GrailsApplication grailsApplication;
    private boolean grailsLayoutConfigLoaded = false;
    private int order = 2147483597;

    public GrailsLayoutViewResolver() {
    }

    public GrailsLayoutViewResolver(ViewResolver innerViewResolver, GroovyPageLayoutFinder groovyPageLayoutFinder) {
        super(innerViewResolver, groovyPageLayoutFinder);
    }

    @Override
    protected View createLayoutView(View innerView) {
        return new GrailsLayoutView(this.groovyPageLayoutFinder, innerView, this.contentProcessor);
    }

    public void init() {
        if (this.servletContext == null) {
            return;
        }
        Factory grailsLayoutFactory = (Factory)this.servletContext.getAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE);
        if (grailsLayoutFactory == null) {
            grailsLayoutFactory = this.loadGrailsLayoutConfig();
        }
        this.contentProcessor = new PageParser2ContentProcessor(grailsLayoutFactory);
    }

    protected Factory loadGrailsLayoutConfig() {
        FilterConfig filterConfig = new FilterConfig(){
            private Map<String, String> customConfig = Collections.singletonMap("configFile", "classpath:org/apache/grails/web/layout/grails-layout-default.xml");

            public ServletContext getServletContext() {
                return GrailsLayoutViewResolver.this.servletContext;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(this.customConfig.keySet());
            }

            public String getInitParameter(String name) {
                return this.customConfig.get(name);
            }

            public String getFilterName() {
                return null;
            }
        };
        Config config = new Config(filterConfig);
        DefaultFactory grailsLayoutFactory = new DefaultFactory(config);
        if (this.servletContext != null) {
            this.servletContext.setAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE, (Object)grailsLayoutFactory);
        }
        grailsLayoutFactory.refresh();
        FactoryHolder.setFactory((Factory)grailsLayoutFactory);
        this.grailsLayoutConfigLoaded = true;
        return grailsLayoutFactory;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void destroy() throws Exception {
        this.clearGrailsLayoutConfig();
    }

    protected void clearGrailsLayoutConfig() {
        if (this.servletContext == null) {
            return;
        }
        if (this.grailsLayoutConfigLoaded) {
            FactoryHolder.setFactory(null);
            if (this.servletContext != null) {
                this.servletContext.removeAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE);
            }
            this.grailsLayoutConfigLoaded = false;
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.init();
    }
}

