/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.controllers;

import grails.config.Settings;
import grails.core.GrailsApplication;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import java.util.EnumSet;
import org.grails.plugins.domain.GrailsDomainClassAutoConfiguration;
import org.grails.web.config.http.GrailsFilters;
import org.grails.web.filters.HiddenHttpMethodFilter;
import org.grails.web.servlet.mvc.GrailsDispatcherServlet;
import org.grails.web.servlet.mvc.GrailsWebRequestFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.autoconfigure.web.servlet.HttpEncodingAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.filter.OrderedCharacterEncodingFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration(before={HttpEncodingAutoConfiguration.class, WebMvcAutoConfiguration.class}, after={GrailsDomainClassAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ControllersAutoConfiguration {
    @Value(value="${grails.filter.encoding:utf-8}")
    private String filtersEncoding;
    @Value(value="${grails.filter.forceEncoding:false}")
    private boolean filtersForceEncoding;
    @Value(value="${grails.resources.cachePeriod:0}")
    private int resourcesCachePeriod;
    @Value(value="${grails.resources.enabled:true}")
    private boolean resourcesEnabled;
    @Value(value="${grails.resources.pattern:/static/**}")
    private String resourcesPattern;
    @Value(value="${grails.controllers.upload.location:#{null}}")
    private String uploadTmpDir;
    @Value(value="${grails.controllers.upload.maxFileSize:128000}")
    private long maxFileSize;
    @Value(value="${grails.controllers.upload.maxRequestSize:128000}")
    private long maxRequestSize;
    @Value(value="${grails.controllers.upload.fileSizeThreshold:0}")
    private int fileSizeThreshold;
    @Value(value="${grails.web.servlet.path:#{null}}")
    String grailsServletPath;

    @Bean
    @ConditionalOnMissingBean(value={CharacterEncodingFilter.class})
    public CharacterEncodingFilter characterEncodingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        OrderedCharacterEncodingFilter characterEncodingFilter = new OrderedCharacterEncodingFilter();
        characterEncodingFilter.setEncoding(this.filtersEncoding);
        characterEncodingFilter.setForceEncoding(this.filtersForceEncoding);
        characterEncodingFilter.setOrder(GrailsFilters.CHARACTER_ENCODING_FILTER.getOrder());
        return characterEncodingFilter;
    }

    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    public FilterRegistrationBean<Filter> hiddenHttpMethodFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new HiddenHttpMethodFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(GrailsFilters.HIDDEN_HTTP_METHOD_FILTER.getOrder());
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={GrailsWebRequestFilter.class})
    public FilterRegistrationBean<Filter> grailsWebRequestFilter(ApplicationContext applicationContext) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        GrailsWebRequestFilter grailsWebRequestFilter = new GrailsWebRequestFilter();
        grailsWebRequestFilter.setApplicationContext(applicationContext);
        registrationBean.setFilter((Filter)grailsWebRequestFilter);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(GrailsFilters.GRAILS_WEB_REQUEST_FILTER.getOrder());
        return registrationBean;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        if (this.uploadTmpDir == null) {
            this.uploadTmpDir = System.getProperty("java.io.tmpdir");
        }
        return new MultipartConfigElement(this.uploadTmpDir, this.maxFileSize, this.maxRequestSize, this.fileSizeThreshold);
    }

    @Bean
    public DispatcherServlet dispatcherServlet() {
        return new GrailsDispatcherServlet();
    }

    @Bean
    public DispatcherServletRegistrationBean dispatcherServletRegistration(GrailsApplication application, DispatcherServlet dispatcherServlet, MultipartConfigElement multipartConfigElement) {
        if (this.grailsServletPath == null) {
            boolean isTomcat = ClassUtils.isPresent((String)"org.apache.catalina.startup.Tomcat", (ClassLoader)application.getClassLoader());
            this.grailsServletPath = isTomcat ? Settings.DEFAULT_TOMCAT_SERVLET_PATH : "/*";
        }
        DispatcherServletRegistrationBean dispatcherServletRegistration = new DispatcherServletRegistrationBean(dispatcherServlet, this.grailsServletPath);
        dispatcherServletRegistration.setLoadOnStartup(2);
        dispatcherServletRegistration.setAsyncSupported(true);
        dispatcherServletRegistration.setMultipartConfig(multipartConfigElement);
        return dispatcherServletRegistration;
    }

    @Bean
    public GrailsWebMvcConfigurer webMvcConfig() {
        return new GrailsWebMvcConfigurer(this.resourcesCachePeriod, this.resourcesEnabled, this.resourcesPattern);
    }

    static class GrailsWebMvcConfigurer
    implements WebMvcConfigurer {
        private static final String[] SERVLET_RESOURCE_LOCATIONS = new String[]{"/"};
        private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"};
        private static final String[] RESOURCE_LOCATIONS = new String[CLASSPATH_RESOURCE_LOCATIONS.length + SERVLET_RESOURCE_LOCATIONS.length];
        boolean addMappings;
        Integer cachePeriod;
        String resourcesPattern;

        GrailsWebMvcConfigurer(Integer cachePeriod, Boolean addMappings, String resourcesPattern) {
            this.addMappings = addMappings;
            this.cachePeriod = cachePeriod;
            this.resourcesPattern = resourcesPattern;
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            if (!this.addMappings) {
                return;
            }
            if (!registry.hasMappingForPattern("/webjars/**")) {
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCachePeriod(this.cachePeriod);
            }
            if (!registry.hasMappingForPattern(this.resourcesPattern)) {
                registry.addResourceHandler(new String[]{this.resourcesPattern}).addResourceLocations(RESOURCE_LOCATIONS).setCachePeriod(this.cachePeriod);
            }
        }

        static {
            System.arraycopy(SERVLET_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, 0, SERVLET_RESOURCE_LOCATIONS.length);
            System.arraycopy(CLASSPATH_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, SERVLET_RESOURCE_LOCATIONS.length, CLASSPATH_RESOURCE_LOCATIONS.length);
        }
    }
}

