/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.bson.query;

import grails.gorm.DetachedCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.codehaus.groovy.runtime.NullObject;
import org.grails.datastore.bson.codecs.CodecCustomTypeMarshaller;
import org.grails.datastore.bson.query.CodecRegistryEmbeddedQueryEncoder;
import org.grails.datastore.bson.query.EmbeddedQueryEncoder;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public abstract class BsonQuery
extends Query {
    public static final String PROJECT_OPERATOR = "$project";
    public static final String SORT_OPERATOR = "$sort";
    public static final String IN_OPERATOR = "$in";
    public static final String OR_OPERATOR = "$or";
    public static final String AND_OPERATOR = "$and";
    public static final String GTE_OPERATOR = "$gte";
    public static final String LTE_OPERATOR = "$lte";
    public static final String GT_OPERATOR = "$gt";
    public static final String LT_OPERATOR = "$lt";
    public static final String NE_OPERATOR = "$ne";
    public static final String EQ_OPERATOR = "$eq";
    public static final String NIN_OPERATOR = "$nin";
    public static final String REGEX_OPERATOR = "$regex";
    public static final String MATCH_OPERATOR = "$match";
    public static final String AVERAGE_OPERATOR = "$avg";
    public static final String GROUP_OPERATOR = "$group";
    public static final String SUM_OPERATOR = "$sum";
    public static final String MIN_OPERATOR = "$min";
    public static final String MAX_OPERATOR = "$max";
    public static final String SIZE_OPERATOR = "$size";
    public static final String NOT_OPERATOR = "$not";
    public static final String NOR_OPERATOR = "$nor";
    public static final String EXISTS_OPERATOR = "$exists";
    public static final String WHERE_OPERATOR = "$where";
    public static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();
    public static final String ID_REFERENCE_SUFFIX = ".$id";
    private static final String THIS_PREFIX = "this.";
    protected static Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    protected static Map<String, OperatorHandler> operatorHandlers = new HashMap<String, OperatorHandler>();
    protected static Map<Class, ProjectionHandler> groupByProjectionHandlers = new HashMap<Class, ProjectionHandler>();
    protected static Map<Class, ProjectionHandler> projectProjectionHandlers = new HashMap<Class, ProjectionHandler>();

    private static List readArrayOfValues(BsonReader queryReader) {
        ArrayList<Object> values = new ArrayList<Object>();
        BsonType bsonType = queryReader.getCurrentBsonType();
        if (bsonType == BsonType.ARRAY) {
            queryReader.readStartArray();
            bsonType = queryReader.readBsonType();
            while (bsonType != BsonType.END_OF_DOCUMENT) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value instanceof NullObject) {
                    value = null;
                }
                values.add(value);
                bsonType = queryReader.readBsonType();
            }
            queryReader.readEndArray();
        }
        return values;
    }

    private static void parseJunctionDocuments(Query.Junction junction, String attributeName, BsonReader queryReader, BsonType bsonType) {
        while (bsonType != BsonType.END_OF_DOCUMENT) {
            if (bsonType == BsonType.DOCUMENT) {
                BsonQuery.parseQueryAttributeValue(queryReader, bsonType, attributeName, junction);
            } else {
                queryReader.skipValue();
            }
            bsonType = queryReader.readBsonType();
        }
    }

    protected BsonQuery(Session session, PersistentEntity entity) {
        super(session, entity);
    }

    protected BsonQuery(PersistentEntity entity) {
        super(null, entity);
    }

    public static Document createBsonQuery(CodecRegistry registry, PersistentEntity entity, List<Query.Criterion> criteria) {
        Query.Conjunction junction = new Query.Conjunction(criteria);
        return BsonQuery.createBsonQuery(registry, entity, (Query.Junction)junction);
    }

    public static Document createBsonQuery(CodecRegistry registry, PersistentEntity entity, Query.Junction junction) {
        CodecRegistryEmbeddedQueryEncoder embeddedQueryEncoder = new CodecRegistryEmbeddedQueryEncoder(registry);
        Document query = new Document();
        if (junction instanceof Query.Conjunction) {
            BsonQuery.populateBsonQuery((EmbeddedQueryEncoder)embeddedQueryEncoder, query, junction.getCriteria(), entity);
        } else {
            BsonQuery.populateBsonQuery((EmbeddedQueryEncoder)embeddedQueryEncoder, query, junction, entity);
        }
        return query;
    }

    public static <T> DetachedCriteria<T> parse(Class<T> type, BsonReader queryReader) {
        queryReader.readStartDocument();
        BsonType bsonType = queryReader.getCurrentBsonType();
        DetachedCriteria criteria = new DetachedCriteria(type);
        Query.Conjunction junction = new Query.Conjunction();
        if (bsonType != BsonType.END_OF_DOCUMENT) {
            String attributeName = queryReader.readName();
            boolean isJunction = false;
            switch (attributeName) {
                case "$or": {
                    junction = new Query.Disjunction();
                    isJunction = true;
                    break;
                }
                case "$not": {
                    junction = new Query.Negation();
                    isJunction = true;
                    break;
                }
                case "$and": {
                    junction = new Query.Conjunction();
                    isJunction = true;
                    break;
                }
                default: {
                    BsonQuery.parseQueryAttributeValue(queryReader, queryReader.getCurrentBsonType(), attributeName, (Query.Junction)junction);
                    bsonType = queryReader.readBsonType();
                }
            }
            criteria.add((Query.Criterion)junction);
            if (isJunction) {
                queryReader.readStartArray();
                bsonType = queryReader.readBsonType();
                while (bsonType != BsonType.END_OF_DOCUMENT) {
                    if (bsonType == BsonType.DOCUMENT) {
                        BsonQuery.parseQueryAttributeValue(queryReader, queryReader.getCurrentBsonType(), attributeName, (Query.Junction)junction);
                    } else {
                        queryReader.skipValue();
                    }
                    bsonType = queryReader.readBsonType();
                }
                queryReader.readEndArray();
            } else {
                while (bsonType != BsonType.END_OF_DOCUMENT) {
                    attributeName = queryReader.readName();
                    bsonType = queryReader.getCurrentBsonType();
                    BsonQuery.parseQueryAttributeValue(queryReader, bsonType, attributeName, (Query.Junction)junction);
                    bsonType = queryReader.readBsonType();
                }
            }
        }
        return criteria;
    }

    private static BsonType parseQueryAttributeValue(BsonReader queryReader, BsonType bsonType, String attributeName, Query.Junction junction) {
        if (bsonType == BsonType.DOCUMENT) {
            queryReader.readStartDocument();
            bsonType = queryReader.getCurrentBsonType();
            while (bsonType != BsonType.END_OF_DOCUMENT) {
                String operator = queryReader.readName();
                OperatorHandler operatorHandler = operatorHandlers.get(operator);
                if (operatorHandler != null) {
                    operatorHandler.handle(junction, attributeName, queryReader);
                } else {
                    BsonQuery.parseQueryAttributeValue(queryReader, queryReader.getCurrentBsonType(), operator, junction);
                }
                bsonType = queryReader.readBsonType();
            }
            queryReader.readEndDocument();
        } else {
            Object value = BsonQuery.readBsonValue(queryReader, bsonType);
            if (value != null) {
                if (value instanceof NullObject) {
                    junction.add((Query.Criterion)new Query.IsNull(attributeName));
                } else {
                    junction.add((Query.Criterion)new Query.Equals(attributeName, value));
                }
            }
        }
        return bsonType;
    }

    protected static Object readBsonValue(BsonReader queryReader, BsonType bsonType) {
        Object value = null;
        switch (bsonType) {
            case STRING: {
                value = queryReader.readString();
                break;
            }
            case INT32: {
                value = queryReader.readInt32();
                break;
            }
            case INT64: {
                value = queryReader.readInt64();
                break;
            }
            case BOOLEAN: {
                value = queryReader.readBoolean();
                break;
            }
            case DOUBLE: {
                value = queryReader.readDouble();
                break;
            }
            case BINARY: {
                value = queryReader.readBinaryData().getData();
                break;
            }
            case REGULAR_EXPRESSION: {
                value = queryReader.readRegularExpression().getPattern();
                break;
            }
            case DATE_TIME: {
                value = new Date(queryReader.readDateTime());
                break;
            }
            case OBJECT_ID: {
                value = queryReader.readObjectId();
                break;
            }
            case NULL: {
                value = NullObject.getNullObject();
                break;
            }
            default: {
                queryReader.skipValue();
            }
        }
        return value;
    }

    protected static String getPropertyName(PersistentEntity entity, Query.PropertyNameCriterion criterion) {
        String propertyName = criterion.getProperty();
        return BsonQuery.getPropertyName(entity, propertyName);
    }

    protected static String getPropertyName(PersistentEntity entity, String propertyName) {
        if (entity.isIdentityName((String)propertyName)) {
            String targetIdentityName = entity.getIdentity().getMapping().getMappedForm().getTargetName();
            if (targetIdentityName != null) {
                propertyName = targetIdentityName;
            }
        } else {
            PersistentProperty property = entity.getPropertyByName((String)propertyName);
            if (property != null) {
                propertyName = MappingUtils.getTargetKey((PersistentProperty)property);
                if (property instanceof ToOne && !(property instanceof Embedded)) {
                    boolean isReference;
                    ToOne association = (ToOne)property;
                    Property attr = association.getMapping().getMappedForm();
                    boolean bl = isReference = attr == null || attr.isReference();
                    if (isReference) {
                        propertyName = (String)propertyName + ID_REFERENCE_SUFFIX;
                    }
                }
            }
        }
        return propertyName;
    }

    private static void addWherePropertyComparison(Document query, String propertyName, String otherPropertyName, String operator) {
        query.put(WHERE_OPERATOR, (Object)(THIS_PREFIX + propertyName + operator + THIS_PREFIX + otherPropertyName));
    }

    private static void handleLike(PersistentEntity entity, Query.Like like, Document query, boolean caseSensitive) {
        Object value = like.getValue();
        String expr = BsonQuery.patternToRegex((Object)value);
        Pattern regex = caseSensitive ? Pattern.compile(expr) : Pattern.compile(expr, 2);
        String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
        query.put(propertyName, (Object)regex);
    }

    protected static List<Object> getInListQueryValues(PersistentEntity entity, Query.In in) {
        ArrayList<Object> values = new ArrayList<Object>(in.getValues().size());
        MappingContext mappingContext = entity.getMappingContext();
        for (Object value : in.getValues()) {
            if (mappingContext.isPersistentEntity(value)) {
                PersistentEntity pe = mappingContext.getPersistentEntity(value.getClass().getName());
                ProxyHandler proxyHandler = mappingContext.getProxyHandler();
                if (proxyHandler.isProxy(value)) {
                    values.add(proxyHandler.getIdentifier(value));
                    continue;
                }
                EntityReflector reflector = mappingContext.getEntityReflector(pe);
                values.add(reflector.getIdentifier(value));
                continue;
            }
            values.add(value);
        }
        return values;
    }

    protected static Document getOrCreatePropertyQuery(Document query, String propertyName) {
        Document queryObject;
        Object existing = query.get((Object)propertyName);
        Document document = queryObject = existing instanceof Document ? (Document)existing : null;
        if (queryObject == null) {
            queryObject = new Document();
        }
        return queryObject;
    }

    private static Integer getNumber(Query.PropertyCriterion criterion) {
        Object value = criterion.getValue();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IllegalArgumentException("Argument to size constraint must be a number");
    }

    protected static void populateBsonQuery(EmbeddedQueryEncoder queryEncoder, Document query, List<Query.Criterion> criteria, PersistentEntity entity) {
        for (Query.Criterion criterion : criteria) {
            QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                CustomTypeMarshaller customTypeMarshaller;
                Query.PropertyCriterion pc;
                PersistentProperty property;
                Document dbo = query;
                if (criterion instanceof Query.PropertyCriterion && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom && !((customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller()) instanceof CodecCustomTypeMarshaller)) {
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle(queryEncoder, criterion, dbo, entity);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    protected static void populateBsonQuery(EmbeddedQueryEncoder queryEncoder, Document query, Query.Junction criteria, PersistentEntity entity) {
        ArrayList<Document> subList = null;
        if (criteria instanceof Query.Disjunction) {
            subList = new ArrayList<Document>();
            query.put(OR_OPERATOR, subList);
        } else if (criteria instanceof Query.Conjunction) {
            subList = new ArrayList();
            query.put(AND_OPERATOR, subList);
        } else if (criteria instanceof Query.Negation) {
            subList = new ArrayList();
            query.put(NOT_OPERATOR, (Object)new Document(OR_OPERATOR, subList));
        }
        for (Query.Criterion criterion : criteria.getCriteria()) {
            QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                Query.PropertyCriterion pc;
                PersistentProperty property;
                Document dbo = query;
                if (subList != null) {
                    dbo = new Document();
                    subList.add(dbo);
                }
                if (criterion instanceof Query.PropertyCriterion && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom) {
                    CustomTypeMarshaller customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller();
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle(queryEncoder, criterion, dbo, entity);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new QueryHandler<Query.IdEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IdEquals criterion, Document query, PersistentEntity entity) {
                Object value = criterion.getValue();
                MappingContext mappingContext = entity.getMappingContext();
                PersistentProperty identity = entity.getIdentity();
                Object converted = mappingContext.getConversionService().convert(value, identity.getType());
                Property mappedForm = identity.getMapping().getMappedForm();
                String targetProperty = mappedForm.getTargetName();
                if (targetProperty == null) {
                    targetProperty = identity.getName();
                }
                query.put(targetProperty, converted);
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Equals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                PersistentProperty persistentProperty = entity.getPropertyByName(criterion.getProperty());
                Object value = persistentProperty instanceof Embedded && criterion.getValue() != null ? queryEncoder.encode((Embedded)persistentProperty, criterion.getValue()) : criterion.getValue();
                if (value instanceof Pattern) {
                    Pattern pattern = (Pattern)value;
                    query.put(propertyName, (Object)new Document(BsonQuery.REGEX_OPERATOR, (Object)pattern.toString()));
                } else {
                    query.put(propertyName, value);
                }
            }
        });
        queryHandlers.put(Query.IsNull.class, new QueryHandler<Query.IsNull>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IsNull criterion, Document query, PersistentEntity entity) {
                queryHandlers.get(Query.Equals.class).handle(queryEncoder, new Query.Equals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler<Query.IsNotNull>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IsNotNull criterion, Document query, PersistentEntity entity) {
                queryHandlers.get(Query.NotEquals.class).handle(queryEncoder, new Query.NotEquals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.EqualsProperty.class, new QueryHandler<Query.EqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.EqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "==");
            }
        });
        queryHandlers.put(Query.NotEqualsProperty.class, new QueryHandler<Query.NotEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.NotEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "!=");
            }
        });
        queryHandlers.put(Query.GreaterThanProperty.class, new QueryHandler<Query.GreaterThanProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">");
            }
        });
        queryHandlers.put(Query.LessThanProperty.class, new QueryHandler<Query.LessThanProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<");
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsProperty.class, new QueryHandler<Query.GreaterThanEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">=");
            }
        });
        queryHandlers.put(Query.LessThanEqualsProperty.class, new QueryHandler<Query.LessThanEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = BsonQuery.getPropertyName(entity, criterion.getOtherProperty());
                BsonQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<=");
            }
        });
        queryHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.NotEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document notEqualQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                notEqualQuery.put(BsonQuery.NE_OPERATOR, criterion.getValue());
                query.put(propertyName, (Object)notEqualQuery);
            }
        });
        queryHandlers.put(Query.Like.class, new QueryHandler<Query.Like>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Like like, Document query, PersistentEntity entity) {
                BsonQuery.handleLike(entity, like, query, true);
            }
        });
        queryHandlers.put(Query.ILike.class, new QueryHandler<Query.ILike>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.ILike like, Document query, PersistentEntity entity) {
                BsonQuery.handleLike(entity, (Query.Like)like, query, false);
            }
        });
        queryHandlers.put(Query.RLike.class, new QueryHandler<Query.RLike>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.RLike like, Document query, PersistentEntity entity) {
                Object value = like.getValue();
                if (value == null) {
                    value = "null";
                }
                String expr = value.toString();
                Pattern regex = Pattern.compile(expr);
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
                query.put(propertyName, (Object)regex);
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.In in, Document query, PersistentEntity entity) {
                Document inQuery = new Document();
                List<Object> values = BsonQuery.getInListQueryValues(entity, in);
                inQuery.put(BsonQuery.IN_OPERATOR, values);
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                query.put(propertyName, (Object)inQuery);
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Between between, Document query, PersistentEntity entity) {
                Document betweenQuery = new Document();
                betweenQuery.put(BsonQuery.GTE_OPERATOR, between.getFrom());
                betweenQuery.put(BsonQuery.LTE_OPERATOR, between.getTo());
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                query.put(propertyName, (Object)betweenQuery);
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThan criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document greaterThanQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                greaterThanQuery.put(BsonQuery.GT_OPERATOR, criterion.getValue());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document greaterThanQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                greaterThanQuery.put(BsonQuery.GTE_OPERATOR, criterion.getValue());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThan criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document lessThanQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                lessThanQuery.put(BsonQuery.LT_OPERATOR, criterion.getValue());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document lessThanQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                lessThanQuery.put(BsonQuery.LTE_OPERATOR, criterion.getValue());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.Conjunction.class, new QueryHandler<Query.Conjunction>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Conjunction criterion, Document query, PersistentEntity entity) {
                BsonQuery.populateBsonQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.Negation.class, new QueryHandler<Query.Negation>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Negation criteria, Document query, PersistentEntity entity) {
                ArrayList<Document> nor = new ArrayList<Document>();
                query.put(BsonQuery.NOR_OPERATOR, nor);
                for (Query.Criterion criterion : criteria.getCriteria()) {
                    Query.PropertyCriterion pc;
                    PersistentProperty property;
                    Document negatedQuery = new Document();
                    nor.add(negatedQuery);
                    if (criterion instanceof Query.PropertyCriterion && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom) {
                        CustomTypeMarshaller customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller();
                        customTypeMarshaller.query(property, pc, (Object)query);
                        continue;
                    }
                    QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
                    if (queryHandler != null) {
                        queryHandler.handle(queryEncoder, criterion, negatedQuery, entity);
                        continue;
                    }
                    throw new UnsupportedOperationException("Query of type " + criterion.getClass().getSimpleName() + " cannot be negated");
                }
            }
        });
        queryHandlers.put(Query.Disjunction.class, new QueryHandler<Query.Disjunction>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Disjunction criterion, Document query, PersistentEntity entity) {
                BsonQuery.populateBsonQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.SizeEquals.class, new QueryHandler<Query.SizeEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document sizeEqualsQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                sizeEqualsQuery.put(BsonQuery.SIZE_OPERATOR, (Object)BsonQuery.getNumber((Query.PropertyCriterion)criterion));
                query.put(propertyName, (Object)sizeEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeNotEquals.class, new QueryHandler<Query.SizeNotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeNotEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document sizeNotEqualsQuery = BsonQuery.getOrCreatePropertyQuery(query, propertyName);
                sizeNotEqualsQuery.put(BsonQuery.NOT_OPERATOR, (Object)new Document(BsonQuery.SIZE_OPERATOR, (Object)BsonQuery.getNumber((Query.PropertyCriterion)criterion)));
                query.put(propertyName, (Object)sizeNotEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeGreaterThan.class, new QueryHandler<Query.SizeGreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeGreaterThan criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = BsonQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + "." + greaterThanValue, (Object)new Document(BsonQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        queryHandlers.put(Query.SizeLessThan.class, new QueryHandler<Query.SizeLessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeLessThan criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = BsonQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + "." + (lessThanValue - 1), (Object)new Document(BsonQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeLessThanEquals.class, new QueryHandler<Query.SizeLessThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeLessThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = BsonQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + "." + lessThanValue, (Object)new Document(BsonQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeGreaterThanEquals.class, new QueryHandler<Query.SizeGreaterThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeGreaterThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = BsonQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = BsonQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + "." + (greaterThanValue - 1), (Object)new Document(BsonQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        operatorHandlers.put(GT_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.GreaterThan(attributeName, value));
                }
            }
        });
        operatorHandlers.put(GTE_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.GreaterThanEquals(attributeName, value));
                }
            }
        });
        operatorHandlers.put(LT_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.LessThan(attributeName, value));
                }
            }
        });
        operatorHandlers.put(LTE_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.LessThanEquals(attributeName, value));
                }
            }
        });
        operatorHandlers.put(NE_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.NotEquals(attributeName, value));
                }
            }
        });
        operatorHandlers.put(EQ_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null) {
                    criteria.add((Query.Criterion)new Query.Equals(attributeName, value));
                }
            }
        });
        operatorHandlers.put(REGEX_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Object value = BsonQuery.readBsonValue(queryReader, queryReader.getCurrentBsonType());
                if (value != null && !(value instanceof NullObject)) {
                    criteria.add((Query.Criterion)new Query.RLike(attributeName, value.toString()));
                }
            }
        });
        operatorHandlers.put(OR_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Query.Disjunction disjunction = new Query.Disjunction();
                criteria.add((Query.Criterion)disjunction);
                queryReader.readStartArray();
                BsonType bsonType = queryReader.readBsonType();
                BsonQuery.parseJunctionDocuments((Query.Junction)disjunction, attributeName, queryReader, bsonType);
                queryReader.readEndArray();
            }
        });
        operatorHandlers.put(IN_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                List values = BsonQuery.readArrayOfValues(queryReader);
                criteria.add((Query.Criterion)new Query.In(attributeName, (Collection)values));
            }
        });
        operatorHandlers.put(NIN_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Query.Negation negation = new Query.Negation();
                List values = BsonQuery.readArrayOfValues(queryReader);
                negation.add((Query.Criterion)new Query.In(attributeName, (Collection)values));
                criteria.add((Query.Criterion)negation);
            }
        });
        operatorHandlers.put(NOT_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Query.Negation negation = new Query.Negation();
                criteria.add((Query.Criterion)negation);
                queryReader.readStartArray();
                BsonType bsonType = queryReader.readBsonType();
                BsonQuery.parseJunctionDocuments((Query.Junction)negation, attributeName, queryReader, bsonType);
                queryReader.readEndArray();
            }
        });
        operatorHandlers.put(AND_OPERATOR, new OperatorHandler(){

            @Override
            public void handle(Query.Junction criteria, String attributeName, BsonReader queryReader) {
                Query.Conjunction conj = new Query.Conjunction();
                criteria.add((Query.Criterion)conj);
                queryReader.readStartArray();
                BsonType bsonType = queryReader.readBsonType();
                BsonQuery.parseJunctionDocuments((Query.Junction)conj, attributeName, queryReader, bsonType);
                queryReader.readEndArray();
            }
        });
    }

    protected static interface OperatorHandler {
        public void handle(Query.Junction var1, String var2, BsonReader var3);
    }

    protected static interface QueryHandler<T> {
        public void handle(EmbeddedQueryEncoder var1, T var2, Document var3, PersistentEntity var4);
    }

    protected static interface ProjectionHandler<T extends Query.Projection> {
        public String handle(PersistentEntity var1, Document var2, Document var3, T var4);
    }
}

