/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcType;
import org.apache.gobblin.source.extractor.JobCommitPolicy;
import org.apache.gobblin.writer.commands.JdbcBufferedInserter;
import org.apache.gobblin.writer.commands.JdbcWriterCommands;
import org.apache.gobblin.writer.commands.TeradataBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataWriterCommands
implements JdbcWriterCommands {
    private static final Logger LOG = LoggerFactory.getLogger(TeradataWriterCommands.class);
    private static final String CREATE_TABLE_SQL_FORMAT = "CREATE MULTISET TABLE %s.%s AS (SELECT * FROM %s.%s) WITH NO DATA NO PRIMARY INDEX";
    private static final String SELECT_SQL_FORMAT = "SELECT COUNT(*) FROM %s.%s";
    private static final String TRUNCATE_TABLE_FORMAT = "DELETE FROM %s.%s ALL";
    private static final String DROP_TABLE_SQL_FORMAT = "DROP TABLE %s.%s";
    private static final String DBC_COLUMNS_SELECT_SQL_PSTMT = "SELECT columnName, columnType FROM dbc.columns WHERE databasename = ? AND tablename = ?";
    private static final String COPY_INSERT_STATEMENT_FORMAT = "INSERT INTO %s.%s SELECT * FROM %s.%s";
    private static final String DELETE_STATEMENT_FORMAT = "DELETE FROM %s.%s";
    private final JdbcBufferedInserter jdbcBufferedWriter;
    private final Connection conn;

    public TeradataWriterCommands(State state, Connection conn, boolean overwriteRecords) throws UnsupportedOperationException {
        if (overwriteRecords) {
            throw new IllegalArgumentException("Replace existing records is not supported in TeradataWriterCommands");
        }
        this.conn = conn;
        this.jdbcBufferedWriter = new TeradataBufferedInserter(state, conn);
    }

    @Override
    public void setConnectionParameters(Properties properties, Connection conn) throws SQLException {
        boolean jobCommitPolicyIsFull = JobCommitPolicy.COMMIT_ON_FULL_SUCCESS.equals((Object)JobCommitPolicy.getCommitPolicy((Properties)properties));
        boolean publishDataAtJobLevel = Boolean.parseBoolean(properties.getProperty("publish.data.at.job.level", String.valueOf(true)));
        if (jobCommitPolicyIsFull || publishDataAtJobLevel) {
            this.conn.setAutoCommit(false);
        } else {
            LOG.info("Writing without staging tables, transactions are handled by the driver");
        }
    }

    @Override
    public void insert(String databaseName, String table, JdbcEntryData jdbcEntryData) throws SQLException {
        this.jdbcBufferedWriter.insert(databaseName, table, jdbcEntryData);
    }

    @Override
    public void flush() throws SQLException {
        this.jdbcBufferedWriter.flush();
    }

    @Override
    public void createTableStructure(String databaseName, String fromStructure, String targetTableName) throws SQLException {
        String sql = String.format(CREATE_TABLE_SQL_FORMAT, databaseName, targetTableName, databaseName, fromStructure);
        this.execute(sql);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isEmpty(String database, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void truncate(String database, String table) throws SQLException {
        String sql = String.format(TRUNCATE_TABLE_FORMAT, database, table);
        this.execute(sql);
    }

    @Override
    public void deleteAll(String database, String table) throws SQLException {
        String deleteSql = String.format(DELETE_STATEMENT_FORMAT, database, table);
        this.execute(deleteSql);
    }

    @Override
    public void drop(String database, String table) throws SQLException {
        LOG.info("Dropping table " + table);
        String sql = String.format(DROP_TABLE_SQL_FORMAT, database, table);
        this.execute(sql);
    }

    @Override
    public Map<String, JdbcType> retrieveDateColumns(String database, String table) throws SQLException {
        ImmutableMap targetDataTypes = ImmutableMap.builder().put((Object)"AT", (Object)JdbcType.TIME).put((Object)"DA", (Object)JdbcType.DATE).put((Object)"TS", (Object)JdbcType.TIMESTAMP).build();
        ImmutableMap.Builder dateColumnsBuilder = ImmutableMap.builder();
        try (PreparedStatement pstmt = this.conn.prepareStatement(DBC_COLUMNS_SELECT_SQL_PSTMT, 1005, 1008);){
            pstmt.setString(1, database);
            pstmt.setString(2, table);
            LOG.info("Retrieving column type information from SQL: " + pstmt);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.first()) {
                    throw new IllegalArgumentException("No result from information_schema.columns");
                }
                do {
                    String type;
                    JdbcType convertedType;
                    if ((convertedType = (JdbcType)((Object)targetDataTypes.get(type = rs.getString("columnType").toUpperCase()))) == null) continue;
                    dateColumnsBuilder.put((Object)rs.getString("columnName"), (Object)convertedType);
                } while (rs.next());
            }
        }
        return dateColumnsBuilder.build();
    }

    @Override
    public void copyTable(String databaseName, String from, String to) throws SQLException {
        String sql = String.format(COPY_INSERT_STATEMENT_FORMAT, databaseName, to, databaseName, from);
        this.execute(sql);
    }

    private void execute(String sql) throws SQLException {
        LOG.info("Executing SQL " + sql);
        try (PreparedStatement pstmt = this.conn.prepareStatement(sql);){
            pstmt.execute();
        }
    }

    public String toString() {
        return String.format("TeradataWriterCommands [bufferedWriter=%s]", this.jdbcBufferedWriter);
    }
}

