/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.commands.JdbcWriterCommands;
import org.apache.gobblin.writer.commands.MySqlWriterCommands;
import org.apache.gobblin.writer.commands.PostgresWriterCommands;
import org.apache.gobblin.writer.commands.TeradataWriterCommands;

public class JdbcWriterCommandsFactory {
    public JdbcWriterCommands newInstance(Destination destination, Connection conn) {
        boolean overwriteRecords = destination.getProperties().getPropAsBoolean("allow.jdbc.record.overwrite");
        switch (destination.getType()) {
            case MYSQL: {
                return new MySqlWriterCommands(destination.getProperties(), conn, overwriteRecords);
            }
            case TERADATA: {
                return new TeradataWriterCommands(destination.getProperties(), conn, overwriteRecords);
            }
            case POSTGRES: {
                return new PostgresWriterCommands(destination.getProperties(), conn, overwriteRecords);
            }
        }
        throw new IllegalArgumentException(destination.getType() + " is not supported");
    }

    public JdbcWriterCommands newInstance(State state, Connection conn) {
        String destKey = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.destination.type", (int)state.getPropAsInt("fork.branches", 1), (int)state.getPropAsInt("fork.branch.id", 0));
        String destType = state.getProp(destKey);
        Preconditions.checkNotNull((Object)destType, (Object)(destKey + " is required for underlying JDBC product name"));
        return this.newInstance(Destination.of((Destination.DestinationType)Destination.DestinationType.valueOf((String)destType.toUpperCase()), (State)state), conn);
    }
}

