/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.jdbc.DataSourceBuilder;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.JdbcWriterBuilder;
import org.apache.gobblin.writer.commands.JdbcWriterCommands;
import org.apache.gobblin.writer.commands.JdbcWriterCommandsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcWriter
implements DataWriter<JdbcEntryData> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcWriter.class);
    public static final String ENABLE_AUTO_COMMIT = "jdbcWriter.enableAutoCommit";
    private final Connection conn;
    private final State state;
    private final JdbcWriterCommands commands;
    private final String databaseName;
    private final String tableName;
    private boolean failed;
    private long recordWrittenCount;

    public JdbcWriter(JdbcWriterBuilder builder) {
        this.state = builder.destination.getProperties();
        this.state.setProp("fork.branch.id", (Object)Integer.toString(builder.branch));
        String databaseTableKey = ForkOperatorUtils.getPropertyNameForBranch((String)"jdbc.publisher.database_name", (int)builder.branches, (int)builder.branch);
        this.databaseName = (String)Preconditions.checkNotNull((Object)this.state.getProp(databaseTableKey), (Object)("Staging table is missing with key " + databaseTableKey));
        String stagingTableKey = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.staging.table", (int)builder.branches, (int)builder.branch);
        this.tableName = (String)Preconditions.checkNotNull((Object)this.state.getProp(stagingTableKey), (Object)("Staging table is missing with key " + stagingTableKey));
        try {
            this.conn = this.createConnection();
            this.conn.setAutoCommit(this.state.getPropAsBoolean(ENABLE_AUTO_COMMIT, false));
            this.commands = new JdbcWriterCommandsFactory().newInstance(this.state, this.conn);
            this.commands.setConnectionParameters(this.state.getProperties(), this.conn);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public JdbcWriter(JdbcWriterCommands commands, State state, String databaseName, String table, Connection conn) {
        this.commands = commands;
        this.state = state;
        this.databaseName = databaseName;
        this.tableName = table;
        this.conn = conn;
    }

    private Connection createConnection() throws SQLException {
        DataSource dataSource = DataSourceBuilder.builder().url(this.state.getProp("jdbc.publisher.url")).driver(this.state.getProp("jdbc.publisher.driver")).userName(this.state.getProp("jdbc.publisher.username")).passWord(this.state.getProp("jdbc.publisher.password")).cryptoKeyLocation(this.state.getProp("jdbc.publisher.encrypt_key_loc")).maxActiveConnections(1).state(this.state).build();
        return dataSource.getConnection();
    }

    public void write(JdbcEntryData record) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing " + record);
        }
        try {
            this.commands.insert(this.databaseName, this.tableName, record);
            ++this.recordWrittenCount;
        }
        catch (Exception e) {
            this.failed = true;
            throw new RuntimeException(e);
        }
    }

    public void commit() throws IOException {
        try {
            LOG.info("Flushing pending insert.");
            this.commands.flush();
            LOG.info("Commiting transaction.");
            this.conn.commit();
        }
        catch (Exception e) {
            this.failed = true;
            throw new RuntimeException(e);
        }
    }

    public void cleanup() throws IOException {
    }

    public void close() throws IOException {
        try {
            try {
                if (this.failed && this.conn != null) {
                    this.conn.rollback();
                }
            }
            finally {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long recordsWritten() {
        return this.recordWrittenCount;
    }

    public long bytesWritten() throws IOException {
        return -1L;
    }
}

