/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.extract.CommandOutput;
import org.apache.gobblin.source.extractor.schema.Schema;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.jdbc.JdbcCommand;
import org.apache.gobblin.source.jdbc.JdbcExtractor;
import org.apache.gobblin.source.jdbc.SqlQueryUtils;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataExtractor
extends JdbcExtractor {
    private static final Logger log = LoggerFactory.getLogger(TeradataExtractor.class);
    private static final String TERADATA_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TERADATA_DATE_FORMAT = "yyyy-MM-dd";
    private static final String TERADATA_HOUR_FORMAT = "HH";
    private static final long SAMPLE_RECORD_COUNT = -1L;
    private static final String ELEMENT_DATA_TYPE = "string";
    private static final String TERADATA_SAMPLE_CLAUSE = " sample ";
    private static final Gson gson = new Gson();

    public TeradataExtractor(WorkUnitState workUnitState) {
        super(workUnitState);
    }

    public List<Command> getSchemaMetadata(String schema, String entity) throws SchemaException {
        log.debug("Build query to get schema");
        ArrayList<Command> commands = new ArrayList<Command>();
        String inputQuery = this.workUnit.getProp("source.querybased.query");
        String predicate = "1=0";
        String metadataSql = Strings.isNullOrEmpty((String)inputQuery) ? "select * from " + schema + "." + entity : this.removeSampleClauseFromQuery(inputQuery);
        metadataSql = SqlQueryUtils.addPredicate(metadataSql, predicate);
        commands.add(JdbcExtractor.getCommand(metadataSql, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getHighWatermarkMetadata(String schema, String entity, String watermarkColumn, List<Predicate> predicateList) throws HighWatermarkException {
        log.debug("Build query to get high watermark");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "max(" + Utils.getCoalesceColumnNames((String)watermarkColumn) + ")";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (Strings.isNullOrEmpty((String)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getCountMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        log.debug("Build query to get source record count");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "CAST(COUNT(1) AS BIGINT)";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (Strings.isNullOrEmpty((String)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        query = query + sampleFilter;
        if (!Strings.isNullOrEmpty((String)sampleFilter)) {
            query = "SELECT " + columnProjection + " FROM (" + query.replace(columnProjection, "1 as t") + ") temp";
        }
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getDataMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException {
        log.debug("Build query to extract data");
        ArrayList<Command> commands = new ArrayList<Command>();
        int fetchSize = this.workUnitState.getPropAsInt("source.querybased.jdbc.resultset.fetch.size", 1000);
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (Strings.isNullOrEmpty((String)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        query = query + sampleFilter;
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(JdbcExtractor.getCommand(fetchSize, JdbcCommand.JdbcCommandType.FETCHSIZE));
        return commands;
    }

    public Map<String, String> getDataTypeMap() {
        ImmutableMap dataTypeMap = ImmutableMap.builder().put((Object)"byteint", (Object)"int").put((Object)"smallint", (Object)"int").put((Object)"integer", (Object)"int").put((Object)"bigint", (Object)"long").put((Object)"float", (Object)"float").put((Object)"decimal", (Object)"double").put((Object)"char", (Object)ELEMENT_DATA_TYPE).put((Object)"varchar", (Object)ELEMENT_DATA_TYPE).put((Object)"byte", (Object)"bytes").put((Object)"varbyte", (Object)"bytes").put((Object)"date", (Object)"date").put((Object)"time", (Object)"time").put((Object)"timestamp", (Object)"timestamp").put((Object)"clob", (Object)ELEMENT_DATA_TYPE).put((Object)"blob", (Object)ELEMENT_DATA_TYPE).put((Object)"structured udt", (Object)"array").put((Object)"double precision", (Object)"float").put((Object)"numeric", (Object)"double").put((Object)"real", (Object)"float").put((Object)"character", (Object)ELEMENT_DATA_TYPE).put((Object)"char varying", (Object)ELEMENT_DATA_TYPE).put((Object)"character varying", (Object)ELEMENT_DATA_TYPE).put((Object)"long varchar", (Object)ELEMENT_DATA_TYPE).put((Object)"interval", (Object)ELEMENT_DATA_TYPE).build();
        return dataTypeMap;
    }

    public Iterator<JsonElement> getRecordSetFromSourceApi(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws IOException {
        return null;
    }

    @Override
    public String getConnectionUrl() {
        String urlPrefix = "jdbc:teradata://";
        String host = this.workUnit.getProp("source.conn.host");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (String)"Connectionn host cannot be null or empty at %s", (Object)"source.conn.host");
        String port = this.workUnit.getProp("source.conn.port", "1025");
        String database = this.workUnit.getProp("source.querybased.schema");
        String defaultUrl = urlPrefix + host.trim() + "/TYPE=FASTEXPORT,DATABASE=" + database.trim() + ",DBS_PORT=" + port.trim();
        return host.contains(urlPrefix) ? host.trim() : defaultUrl;
    }

    @Override
    public long extractSampleRecordCountFromQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return -1L;
        }
        long recordcount = -1L;
        String limit = null;
        String inputQuery = query.toLowerCase();
        int limitIndex = inputQuery.indexOf(TERADATA_SAMPLE_CLAUSE);
        if (limitIndex > 0) {
            limit = query.substring(limitIndex + TERADATA_SAMPLE_CLAUSE.length()).trim();
        }
        if (!Strings.isNullOrEmpty(limit)) {
            try {
                recordcount = Long.parseLong(limit);
            }
            catch (Exception e) {
                log.error("Ignoring incorrect limit value in input query: {}", (Object)limit);
            }
        }
        return recordcount;
    }

    @Override
    public String removeSampleClauseFromQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return null;
        }
        String limitString = "";
        String inputQuery = query.toLowerCase();
        int limitIndex = inputQuery.indexOf(TERADATA_SAMPLE_CLAUSE);
        if (limitIndex > 0) {
            limitString = query.substring(limitIndex);
        }
        return query.replace(limitString, "");
    }

    @Override
    public String constructSampleClause() {
        long sampleRowCount = this.getSampleRecordCount();
        if (sampleRowCount >= 0L) {
            return TERADATA_SAMPLE_CLAUSE + sampleRowCount;
        }
        return "";
    }

    public String getWatermarkSourceFormat(WatermarkType watermarkType) {
        String columnFormat = null;
        switch (watermarkType) {
            case TIMESTAMP: {
                columnFormat = TERADATA_TIMESTAMP_FORMAT;
                break;
            }
            case DATE: {
                columnFormat = TERADATA_DATE_FORMAT;
                break;
            }
            case HOUR: {
                columnFormat = TERADATA_HOUR_FORMAT;
                break;
            }
            case SIMPLE: {
                break;
            }
            default: {
                log.error("Watermark type {} not recognized", (Object)watermarkType.toString());
            }
        }
        return columnFormat;
    }

    public String getHourPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting hour predicate for Teradata");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)TERADATA_HOUR_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getDatePredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting date predicate for Teradata");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)TERADATA_DATE_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getTimestampPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting timestamp predicate for Teradata");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)TERADATA_TIMESTAMP_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    @Override
    public JsonArray getSchema(CommandOutput<?, ?> response) throws SchemaException, IOException {
        log.debug("Extract schema from resultset");
        ResultSet resultset = null;
        Iterator itr = response.getResults().values().iterator();
        if (!itr.hasNext()) {
            throw new SchemaException("Failed to get schema from Teradata - empty schema resultset");
        }
        resultset = (ResultSet)itr.next();
        JsonArray fieldJsonArray = new JsonArray();
        try {
            Schema schema = new Schema();
            ResultSetMetaData rsmd = resultset.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String columnName = rsmd.getColumnName(i);
                String columnTypeName = rsmd.getColumnTypeName(i);
                schema.setColumnName(columnName);
                List mapSymbols = null;
                JsonObject newDataType = this.convertDataType(columnName, columnTypeName, ELEMENT_DATA_TYPE, mapSymbols);
                schema.setDataType(newDataType);
                schema.setLength((long)rsmd.getColumnDisplaySize(i));
                schema.setPrecision(rsmd.getPrecision(i));
                schema.setScale(rsmd.getScale(i));
                schema.setNullable(rsmd.isNullable(i) == 1);
                schema.setComment(rsmd.getColumnLabel(i));
                String jsonStr = gson.toJson((Object)schema);
                JsonObject obj = ((JsonObject)gson.fromJson(jsonStr, JsonObject.class)).getAsJsonObject();
                fieldJsonArray.add((JsonElement)obj);
            }
        }
        catch (Exception e) {
            throw new SchemaException("Failed to get schema from Teradaa; error - " + e.getMessage(), e);
        }
        return fieldJsonArray;
    }
}

