/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class SqlQueryUtils {
    public static String addPredicate(String query, String predicateCond) {
        if (Strings.isNullOrEmpty((String)predicateCond)) {
            return query;
        }
        String normalizedQuery = query.toLowerCase().trim();
        Preconditions.checkArgument((boolean)normalizedQuery.contains(" from "), (Object)("query does not contain 'from': " + query));
        Preconditions.checkArgument((!normalizedQuery.contains(" by ") ? 1 : 0) != 0, (Object)("query contains 'order by' or 'group by': " + query));
        Preconditions.checkArgument((!normalizedQuery.contains(" having ") ? 1 : 0) != 0, (Object)("query contains 'having': " + query));
        Preconditions.checkArgument((!normalizedQuery.contains(" limit ") ? 1 : 0) != 0, (Object)("query contains 'limit': " + query));
        String keyword = " where ";
        if (normalizedQuery.contains(keyword)) {
            keyword = " and ";
        }
        query = query + keyword + "(" + predicateCond + ")";
        return query;
    }

    public static boolean castToBoolean(String fieldValue) {
        String lowerField;
        switch (lowerField = fieldValue.toLowerCase()) {
            case "y": {
                return true;
            }
            case "n": {
                return false;
            }
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "t": {
                return true;
            }
            case "f": {
                return false;
            }
            case "yes": {
                return true;
            }
            case "no": {
                return false;
            }
            case "0": {
                return false;
            }
            case "1": {
                return true;
            }
        }
        return false;
    }
}

