/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.tunnel.Tunnel;

public class JdbcProvider
extends HikariDataSource {
    private static final AtomicInteger POOL_NUM = new AtomicInteger(0);
    private Tunnel tunnel;

    public JdbcProvider(String driver, String connectionUrl, String user, String password, int numconn, int timeout) {
        this.connect(driver, connectionUrl, user, password, numconn, timeout, "DEFAULT", null, -1);
    }

    public JdbcProvider(String driver, String connectionUrl, String user, String password, int numconn, int timeout, String type) {
        this.connect(driver, connectionUrl, user, password, numconn, timeout, type, null, -1);
    }

    public JdbcProvider(String driver, String connectionUrl, String user, String password, int numconn, int timeout, String type, String proxyHost, int proxyPort) {
        this.connect(driver, connectionUrl, user, password, numconn, timeout, type, proxyHost, proxyPort);
    }

    public void connect(String driver, String connectionUrl, String user, String password, int numconn, int timeout, String type, String proxyHost, int proxyPort) {
        if (proxyHost != null && proxyPort > 0) {
            String remoteHost = "";
            int remotePort = 0;
            int hostStart = connectionUrl.indexOf("://") + 3;
            int portStart = connectionUrl.indexOf(":", hostStart);
            remoteHost = connectionUrl.substring(hostStart, portStart);
            remotePort = Integer.decode(connectionUrl.substring(portStart + 1, connectionUrl.indexOf("/", portStart)));
            try {
                String newConnectionUrl;
                this.tunnel = Tunnel.build((String)remoteHost, (int)remotePort, (String)proxyHost, (int)proxyPort);
                int tunnelPort = this.tunnel.getPort();
                connectionUrl = newConnectionUrl = connectionUrl.replaceFirst(remoteHost, "127.0.0.1").replaceFirst(":" + remotePort, ":" + tunnelPort);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to open tunnel to remote host " + remoteHost + ":" + remotePort + " via proxy " + proxyHost + ":" + proxyPort, ioe);
            }
        }
        this.setPoolName("HikariPool-" + POOL_NUM.incrementAndGet() + "-" + ((Object)((Object)this)).getClass().getSimpleName());
        this.setDriverClassName(driver);
        this.setUsername(user);
        this.setPassword(password);
        this.setJdbcUrl(connectionUrl);
        this.setMinimumIdle(0);
        this.setMaximumPoolSize(numconn);
        this.setConnectionTimeout(timeout);
    }

    public synchronized void close() {
        super.close();
        if (this.tunnel != null) {
            this.tunnel.close();
        }
    }
}

