/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.extract.CommandOutput;
import org.apache.gobblin.source.extractor.extract.QueryBasedExtractor;
import org.apache.gobblin.source.extractor.extract.SourceSpecificLayer;
import org.apache.gobblin.source.extractor.resultset.RecordSetList;
import org.apache.gobblin.source.extractor.schema.ColumnAttributes;
import org.apache.gobblin.source.extractor.schema.ColumnNameCase;
import org.apache.gobblin.source.extractor.schema.Schema;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.jdbc.JdbcCommand;
import org.apache.gobblin.source.jdbc.JdbcCommandOutput;
import org.apache.gobblin.source.jdbc.JdbcProvider;
import org.apache.gobblin.source.jdbc.JdbcSpecificLayer;
import org.apache.gobblin.source.jdbc.SqlQueryUtils;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcExtractor
extends QueryBasedExtractor<JsonArray, JsonElement>
implements SourceSpecificLayer<JsonArray, JsonElement>,
JdbcSpecificLayer {
    private static final Gson gson = new Gson();
    private List<String> headerRecord;
    private boolean firstPull = true;
    private CommandOutput<?, ?> dataResponse = null;
    protected String extractSql;
    protected long sampleRecordCount;
    protected JdbcProvider jdbcSource;
    protected Connection dataConnection;
    protected int timeOut;
    private List<ColumnAttributes> columnAliasMap = new ArrayList<ColumnAttributes>();
    private Map<String, Schema> metadataColumnMap = new HashMap<String, Schema>();
    private List<String> metadataColumnList = new ArrayList<String>();
    private String inputColumnProjection;
    private String outputColumnProjection;
    private long totalRecordCount = 0L;
    private boolean nextRecord = true;
    private int unknownColumnCounter = 1;
    protected boolean enableDelimitedIdentifier = false;
    private Logger log = LoggerFactory.getLogger(JdbcExtractor.class);

    public Map<String, Schema> getMetadataColumnMap() {
        return this.metadataColumnMap;
    }

    public void setMetadataColumnMap(Map<String, Schema> metadataColumnMap) {
        this.metadataColumnMap = metadataColumnMap;
    }

    public List<String> getMetadataColumnList() {
        return this.metadataColumnList;
    }

    public void setMetadataColumnList(List<String> metadataColumnList) {
        this.metadataColumnList = metadataColumnList;
    }

    public long getSampleRecordCount() {
        return this.sampleRecordCount;
    }

    public void setSampleRecordCount(long sampleRecordCount) {
        this.sampleRecordCount = sampleRecordCount;
    }

    public String getExtractSql() {
        return this.extractSql;
    }

    public void setExtractSql(String extractSql) {
        this.extractSql = extractSql;
    }

    public String getOutputColumnProjection() {
        return this.outputColumnProjection;
    }

    public void setOutputColumnProjection(String outputColumnProjection) {
        this.outputColumnProjection = outputColumnProjection;
    }

    public String getInputColumnProjection() {
        return this.inputColumnProjection;
    }

    public void setInputColumnProjection(String inputColumnProjection) {
        this.inputColumnProjection = inputColumnProjection;
    }

    public List<ColumnAttributes> getColumnAliasMap() {
        return this.columnAliasMap;
    }

    public void addToColumnAliasMap(ColumnAttributes columnAliasMap) {
        this.columnAliasMap.add(columnAliasMap);
    }

    public boolean isFirstPull() {
        return this.firstPull;
    }

    public void setFirstPull(boolean firstPull) {
        this.firstPull = firstPull;
    }

    protected List<String> getHeaderRecord() {
        return this.headerRecord;
    }

    protected void setHeaderRecord(List<String> headerRecord) {
        this.headerRecord = headerRecord;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean hasNextRecord() {
        return this.nextRecord;
    }

    public void setNextRecord(boolean nextRecord) {
        this.nextRecord = nextRecord;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public Gson getGson() {
        return gson;
    }

    public JdbcExtractor(WorkUnitState workUnitState) {
        super(workUnitState);
    }

    public void extractMetadata(String schema, String entity, WorkUnit workUnit) throws SchemaException, IOException {
        this.log.info("Extract metadata using JDBC");
        String inputQuery = this.workUnitState.getProp("source.querybased.query");
        if (this.workUnitState.getPropAsBoolean("source.querybased.is.metadata.column.check.enabled", Boolean.valueOf("true").booleanValue()) && JdbcExtractor.hasJoinOperation(inputQuery)) {
            throw new RuntimeException("Query across multiple tables not supported");
        }
        String watermarkColumn = this.workUnitState.getProp("extract.delta.fields");
        this.enableDelimitedIdentifier = this.workUnitState.getPropAsBoolean("enable.delimited.identifier", false);
        JsonObject defaultWatermark = this.getDefaultWatermark();
        String derivedWatermarkColumnName = defaultWatermark.get("columnName").getAsString();
        this.setSampleRecordCount(this.extractSampleRecordCountFromQuery(inputQuery));
        inputQuery = this.removeSampleClauseFromQuery(inputQuery);
        JsonArray targetSchema = new JsonArray();
        ArrayList<String> headerColumns = new ArrayList<String>();
        try {
            List cmds = this.getSchemaMetadata(schema, entity);
            CommandOutput<?, ?> response = this.executePreparedSql(cmds);
            JsonArray array = this.getSchema(response);
            this.buildMetadataColumnMap(array);
            this.parseInputQuery(inputQuery);
            List<String> sourceColumns = this.getMetadataColumnList();
            for (ColumnAttributes colMap : this.columnAliasMap) {
                String alias = colMap.getAliasName();
                String columnName = colMap.getColumnName();
                String sourceColumnName = colMap.getSourceColumnName();
                if (!this.isMetadataColumn(columnName, sourceColumns)) continue;
                String targetColumnName = this.getTargetColumnName(columnName, alias);
                Schema obj = this.getUpdatedSchemaObject(columnName, alias, targetColumnName);
                String jsonStr = gson.toJson((Object)obj);
                JsonObject jsonObject = ((JsonObject)gson.fromJson(jsonStr, JsonObject.class)).getAsJsonObject();
                targetSchema.add((JsonElement)jsonObject);
                headerColumns.add(targetColumnName);
                sourceColumnName = this.getLeftDelimitedIdentifier() + sourceColumnName + this.getRightDelimitedIdentifier();
                this.columnList.add(sourceColumnName);
            }
            if (this.hasMultipleWatermarkColumns(watermarkColumn)) {
                derivedWatermarkColumnName = this.getLeftDelimitedIdentifier() + derivedWatermarkColumnName + this.getRightDelimitedIdentifier();
                this.columnList.add(derivedWatermarkColumnName);
                headerColumns.add(derivedWatermarkColumnName);
                targetSchema.add((JsonElement)defaultWatermark);
                this.workUnitState.setProp("extract.delta.fields", (Object)derivedWatermarkColumnName);
            }
            String outputColProjection = Joiner.on((String)",").useForNull("null").join((Iterable)this.columnList);
            outputColProjection = outputColProjection.replace(derivedWatermarkColumnName, Utils.getCoalesceColumnNames((String)watermarkColumn) + " AS " + derivedWatermarkColumnName);
            this.setOutputColumnProjection(outputColProjection);
            String extractQuery = this.getExtractQuery(schema, entity, inputQuery);
            this.setHeaderRecord(headerColumns);
            this.setOutputSchema(targetSchema);
            this.setExtractSql(extractQuery);
            this.log.info("Schema:" + targetSchema);
            this.log.info("Extract query: " + this.getExtractSql());
        }
        catch (IOException | RuntimeException | SchemaException e) {
            throw new SchemaException("Failed to get metadata using JDBC; error - " + e.getMessage(), (Exception)e);
        }
    }

    private String getExtractQuery(String schema, String entity, String inputQuery) {
        String inputColProjection = this.getInputColumnProjection();
        String outputColProjection = this.getOutputColumnProjection();
        String query = inputQuery;
        if (query == null) {
            query = "SELECT " + outputColProjection + " FROM " + schema + "." + entity;
        } else if (StringUtils.isNotBlank((CharSequence)inputColProjection)) {
            query = query.replace(inputColProjection, outputColProjection);
        }
        query = this.addOptionalWatermarkPredicate(query);
        return query;
    }

    protected String addOptionalWatermarkPredicate(String query) {
        String watermarkPredicateSymbol = "'$WATERMARK'";
        if (!query.contains(watermarkPredicateSymbol)) {
            query = SqlQueryUtils.addPredicate(query, watermarkPredicateSymbol);
        }
        return query;
    }

    private Schema getUpdatedSchemaObject(String sourceColumnName, String alias, String targetColumnName) {
        Schema obj = this.getMetadataColumnMap().get(sourceColumnName.toLowerCase());
        if (obj == null && alias != null) {
            obj = this.getMetadataColumnMap().get(alias.toLowerCase());
        }
        if (obj == null) {
            obj = this.getCustomColumnSchema(targetColumnName);
        } else {
            String watermarkColumn = this.workUnitState.getProp("extract.delta.fields");
            String primarykeyColumn = this.workUnitState.getProp("extract.primary.key.fields");
            boolean isMultiColumnWatermark = this.hasMultipleWatermarkColumns(watermarkColumn);
            obj.setColumnName(targetColumnName);
            boolean isWatermarkColumn = this.isWatermarkColumn(watermarkColumn, sourceColumnName);
            if (isWatermarkColumn) {
                this.updateDeltaFieldConfig(sourceColumnName, targetColumnName);
            } else if (alias != null) {
                isWatermarkColumn = this.isWatermarkColumn(watermarkColumn, alias);
                this.updateDeltaFieldConfig(alias, targetColumnName);
            }
            if (!isMultiColumnWatermark) {
                obj.setWaterMark(isWatermarkColumn);
            }
            if (isWatermarkColumn && !isMultiColumnWatermark || this.getPrimarykeyIndex(primarykeyColumn, sourceColumnName) > 0) {
                obj.setNullable(false);
            } else {
                obj.setNullable(true);
            }
            int primarykeyIndex = this.getPrimarykeyIndex(primarykeyColumn, sourceColumnName);
            if (primarykeyIndex > 0 && !sourceColumnName.equalsIgnoreCase(targetColumnName)) {
                this.updatePrimaryKeyConfig(sourceColumnName, targetColumnName);
            }
            obj.setPrimaryKey(primarykeyIndex);
        }
        return obj;
    }

    private String getTargetColumnName(String sourceColumnName, String alias) {
        String targetColumnName = alias;
        Schema obj = this.getMetadataColumnMap().get(sourceColumnName.toLowerCase());
        if (obj == null) {
            targetColumnName = targetColumnName == null ? "unknown" + this.unknownColumnCounter : targetColumnName;
            ++this.unknownColumnCounter;
        } else {
            targetColumnName = StringUtils.isNotBlank((CharSequence)targetColumnName) ? targetColumnName : sourceColumnName;
        }
        targetColumnName = this.toCase(targetColumnName);
        return Utils.escapeSpecialCharacters((String)targetColumnName, (String)"$,&", (String)"_");
    }

    private void buildMetadataColumnMap(JsonArray array) {
        if (array != null) {
            for (JsonElement columnElement : array) {
                Schema schemaObj = (Schema)gson.fromJson(columnElement, Schema.class);
                String columnName = schemaObj.getColumnName();
                this.metadataColumnMap.put(columnName.toLowerCase(), schemaObj);
                this.metadataColumnList.add(columnName.toLowerCase());
            }
        }
    }

    private void updateDeltaFieldConfig(String srcColumnName, String tgtColumnName) {
        if (this.workUnitState.contains("extract.delta.fields")) {
            String watermarkCol = this.workUnitState.getProp("extract.delta.fields");
            this.workUnitState.setProp("extract.delta.fields", (Object)watermarkCol.replaceAll(srcColumnName, tgtColumnName));
        }
    }

    private void updatePrimaryKeyConfig(String srcColumnName, String tgtColumnName) {
        if (this.workUnitState.contains("extract.primary.key.fields")) {
            String primarykey = this.workUnitState.getProp("extract.primary.key.fields");
            this.workUnitState.setProp("extract.primary.key.fields", (Object)primarykey.replaceAll(srcColumnName, tgtColumnName));
        }
    }

    private boolean isSelectAllColumns() {
        String columnProjection = this.getInputColumnProjection();
        return columnProjection == null || columnProjection.trim().equals("*") || columnProjection.contains(".*");
    }

    private void parseInputQuery(String query) {
        ArrayList<String> projectedColumns = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            String queryLowerCase = query.toLowerCase();
            int startIndex = queryLowerCase.indexOf("select ") + 7;
            int endIndex = queryLowerCase.indexOf(" from ");
            if (startIndex >= 0 && endIndex >= 0) {
                String columnProjection = query.substring(startIndex, endIndex);
                this.setInputColumnProjection(columnProjection);
                StringBuffer sb = new StringBuffer();
                int bracketCount = 0;
                for (int i = 0; i < columnProjection.length(); ++i) {
                    char c = columnProjection.charAt(i);
                    if (c == '(') {
                        ++bracketCount;
                    }
                    if (c == ')') {
                        --bracketCount;
                    }
                    if (bracketCount != 0) {
                        sb.append(c);
                        continue;
                    }
                    if (c != ',') {
                        sb.append(c);
                        continue;
                    }
                    projectedColumns.add(sb.toString());
                    sb = new StringBuffer();
                }
                projectedColumns.add(sb.toString());
            }
        }
        if (this.isSelectAllColumns()) {
            List<String> columnList = this.getMetadataColumnList();
            for (String columnName : columnList) {
                ColumnAttributes col = new ColumnAttributes();
                col.setColumnName(columnName);
                col.setAliasName(columnName);
                col.setSourceColumnName(columnName);
                this.addToColumnAliasMap(col);
            }
        } else {
            for (String projectedColumn : projectedColumns) {
                String column = projectedColumn.trim();
                String alias = null;
                String sourceColumn = column;
                int spaceOccurences = StringUtils.countMatches((CharSequence)column.trim(), (CharSequence)" ");
                if (spaceOccurences > 0) {
                    int lastSpaceIndex = column.toLowerCase().lastIndexOf(" as ");
                    sourceColumn = column.substring(0, lastSpaceIndex);
                    alias = column.substring(lastSpaceIndex + 4);
                }
                String columnName = sourceColumn;
                if (sourceColumn.contains(".")) {
                    columnName = sourceColumn.substring(sourceColumn.indexOf(".") + 1);
                }
                ColumnAttributes col = new ColumnAttributes();
                col.setColumnName(columnName);
                col.setAliasName(alias);
                col.setSourceColumnName(sourceColumn);
                this.addToColumnAliasMap(col);
            }
        }
    }

    private CommandOutput<?, ?> executeSql(List<Command> cmds) {
        String query = null;
        int fetchSize = 0;
        block6: for (Command cmd : cmds) {
            if (!(cmd instanceof JdbcCommand)) continue;
            JdbcCommand.JdbcCommandType type = (JdbcCommand.JdbcCommandType)cmd.getCommandType();
            switch (type) {
                case QUERY: {
                    query = (String)cmd.getParams().get(0);
                    continue block6;
                }
                case FETCHSIZE: {
                    fetchSize = Integer.parseInt((String)cmd.getParams().get(0));
                    continue block6;
                }
            }
            this.log.error("Command " + type.toString() + " not recognized");
        }
        this.log.info("Executing query:" + query);
        ResultSet resultSet = null;
        try {
            boolean status;
            this.jdbcSource = this.createJdbcSource();
            if (this.dataConnection == null) {
                this.dataConnection = this.jdbcSource.getConnection();
            }
            Statement statement = this.dataConnection.createStatement();
            if (fetchSize != 0 && this.getExpectedRecordCount() > 2000L) {
                statement.setFetchSize(fetchSize);
            }
            if (!(status = statement.execute(query))) {
                this.log.error("Failed to execute sql:" + query);
            }
            resultSet = statement.getResultSet();
        }
        catch (Exception e) {
            this.log.error("Failed to execute sql:" + query + " ;error-" + e.getMessage(), (Throwable)e);
        }
        JdbcCommandOutput output = new JdbcCommandOutput();
        output.put((JdbcCommand)cmds.get(0), resultSet);
        return output;
    }

    private CommandOutput<?, ?> executePreparedSql(List<Command> cmds) {
        String query = null;
        List queryParameters = null;
        int fetchSize = 0;
        block7: for (Command cmd : cmds) {
            if (!(cmd instanceof JdbcCommand)) continue;
            JdbcCommand.JdbcCommandType type = (JdbcCommand.JdbcCommandType)cmd.getCommandType();
            switch (type) {
                case QUERY: {
                    query = (String)cmd.getParams().get(0);
                    continue block7;
                }
                case QUERYPARAMS: {
                    queryParameters = cmd.getParams();
                    continue block7;
                }
                case FETCHSIZE: {
                    fetchSize = Integer.parseInt((String)cmd.getParams().get(0));
                    continue block7;
                }
            }
            this.log.error("Command " + type.toString() + " not recognized");
        }
        this.log.info("Executing query:" + query);
        ResultSet resultSet = null;
        try {
            boolean status;
            this.jdbcSource = this.createJdbcSource();
            if (this.dataConnection == null) {
                this.dataConnection = this.jdbcSource.getConnection();
            }
            PreparedStatement statement = this.dataConnection.prepareStatement(query, 1003, 1007);
            int parameterPosition = 1;
            if (queryParameters != null && queryParameters.size() > 0) {
                for (String parameter : queryParameters) {
                    statement.setString(parameterPosition, parameter);
                    ++parameterPosition;
                }
            }
            if (fetchSize != 0) {
                statement.setFetchSize(fetchSize);
            }
            if (!(status = statement.execute())) {
                this.log.error("Failed to execute sql:" + query);
            }
            resultSet = statement.getResultSet();
        }
        catch (Exception e) {
            this.log.error("Failed to execute sql:" + query + " ;error-" + e.getMessage(), (Throwable)e);
        }
        JdbcCommandOutput output = new JdbcCommandOutput();
        output.put((JdbcCommand)cmds.get(0), resultSet);
        return output;
    }

    protected JdbcProvider createJdbcSource() {
        int proxyPort;
        String driver = this.workUnitState.getProp("source.conn.driver");
        String userName = this.workUnitState.getProp("source.conn.username");
        String password = PasswordManager.getInstance((State)this.workUnitState).readPassword(this.workUnitState.getProp("source.conn.password"));
        String connectionUrl = this.getConnectionUrl();
        String proxyHost = this.workUnitState.getProp("source.conn.use.proxy.url");
        int n = proxyPort = this.workUnitState.getProp("source.conn.use.proxy.port") != null ? this.workUnitState.getPropAsInt("source.conn.use.proxy.port") : -1;
        if (this.jdbcSource == null || this.jdbcSource.isClosed()) {
            this.jdbcSource = new JdbcProvider(driver, connectionUrl, userName, password, 1, this.getTimeOut(), "DEFAULT", proxyHost, proxyPort);
            return this.jdbcSource;
        }
        return this.jdbcSource;
    }

    public long getMaxWatermark(String schema, String entity, String watermarkColumn, List<Predicate> predicateList, String watermarkSourceFormat) throws HighWatermarkException {
        this.log.info("Get high watermark using JDBC");
        long calculatedHighWatermark = -1L;
        try {
            List cmds = this.getHighWatermarkMetadata(schema, entity, watermarkColumn, predicateList);
            CommandOutput<?, ?> response = this.executeSql(cmds);
            calculatedHighWatermark = this.getHighWatermark(response, watermarkColumn, watermarkSourceFormat);
            return calculatedHighWatermark;
        }
        catch (Exception e) {
            throw new HighWatermarkException("Failed to get high watermark using JDBC; error - " + e.getMessage(), e);
        }
    }

    public long getSourceCount(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        this.log.info("Get source record count using JDBC");
        long count = 0L;
        try {
            List cmds = this.getCountMetadata(schema, entity, workUnit, predicateList);
            CommandOutput<?, ?> response = this.executeSql(cmds);
            count = this.getCount(response);
            this.log.info("Source record count:" + count);
            return count;
        }
        catch (Exception e) {
            throw new RecordCountException("Failed to get source record count using JDBC; error - " + e.getMessage(), e);
        }
    }

    public Iterator<JsonElement> getRecordSet(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException, IOException {
        Iterator<JsonElement> rs = null;
        try {
            if (this.isFirstPull()) {
                this.log.info("Get data recordset using JDBC");
                List cmds = this.getDataMetadata(schema, entity, workUnit, predicateList);
                this.dataResponse = this.executePreparedSql(cmds);
                this.setFirstPull(false);
            }
            rs = this.getData(this.dataResponse);
            return rs;
        }
        catch (Exception e) {
            throw new DataRecordException("Failed to get record set using JDBC; error - " + e.getMessage(), e);
        }
    }

    public JsonArray getSchema(CommandOutput<?, ?> response) throws SchemaException, IOException {
        this.log.debug("Extract schema from resultset");
        ResultSet resultset = null;
        Iterator itr = response.getResults().values().iterator();
        if (!itr.hasNext()) {
            throw new SchemaException("Failed to get schema from database - Resultset has no records");
        }
        resultset = (ResultSet)itr.next();
        JsonArray fieldJsonArray = new JsonArray();
        try {
            while (resultset.next()) {
                Schema schema = new Schema();
                String columnName = resultset.getString(1);
                schema.setColumnName(columnName);
                String dataType = resultset.getString(2);
                String elementDataType = "string";
                List mapSymbols = null;
                JsonObject newDataType = this.convertDataType(columnName, dataType, elementDataType, mapSymbols);
                schema.setDataType(newDataType);
                schema.setLength(resultset.getLong(3));
                schema.setPrecision(resultset.getInt(4));
                schema.setScale(resultset.getInt(5));
                schema.setNullable(resultset.getBoolean(6));
                schema.setFormat(resultset.getString(7));
                schema.setComment(resultset.getString(8));
                schema.setDefaultValue(null);
                schema.setUnique(false);
                String jsonStr = gson.toJson((Object)schema);
                JsonObject obj = ((JsonObject)gson.fromJson(jsonStr, JsonObject.class)).getAsJsonObject();
                fieldJsonArray.add((JsonElement)obj);
            }
        }
        catch (Exception e) {
            throw new SchemaException("Failed to get schema from database; error - " + e.getMessage(), e);
        }
        return fieldJsonArray;
    }

    public long getHighWatermark(CommandOutput<?, ?> response, String watermarkColumn, String watermarkColumnFormat) throws HighWatermarkException {
        Long HighWatermark;
        block7: {
            this.log.debug("Extract high watermark from resultset");
            ResultSet resultset = null;
            Iterator itr = response.getResults().values().iterator();
            if (!itr.hasNext()) {
                throw new HighWatermarkException("Failed to get high watermark from database - Resultset has no records");
            }
            resultset = (ResultSet)itr.next();
            try {
                String watermark = resultset.next() ? resultset.getString(1) : null;
                if (watermark == null) {
                    return -1L;
                }
                if (watermarkColumnFormat != null) {
                    SimpleDateFormat inFormat = new SimpleDateFormat(watermarkColumnFormat);
                    Date date = null;
                    try {
                        date = inFormat.parse(watermark);
                    }
                    catch (ParseException e) {
                        this.log.error("ParseException: " + e.getMessage(), (Throwable)e);
                    }
                    SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    HighWatermark = Long.parseLong(outFormat.format(date));
                    break block7;
                }
                HighWatermark = Long.parseLong(watermark);
            }
            catch (Exception e) {
                throw new HighWatermarkException("Failed to get high watermark from database; error - " + e.getMessage(), e);
            }
        }
        return HighWatermark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getCount(CommandOutput<?, ?> response) throws RecordCountException {
        this.log.debug("Extract source record count from resultset");
        ResultSet resultset = null;
        long count = 0L;
        Iterator itr = response.getResults().values().iterator();
        if (!itr.hasNext()) throw new RuntimeException("Failed to get source record count from database - Resultset has no records");
        resultset = (ResultSet)itr.next();
        try {
            if (!resultset.next()) return count;
            return resultset.getLong(1);
        }
        catch (Exception e) {
            throw new RecordCountException("Failed to get source record count from database; error - " + e.getMessage(), e);
        }
    }

    public Iterator<JsonElement> getData(CommandOutput<?, ?> response) throws DataRecordException, IOException {
        this.log.debug("Extract data records from resultset");
        RecordSetList<JsonElement> recordSet = this.getNewRecordSetList();
        if (response == null || !this.hasNextRecord()) {
            return recordSet.iterator();
        }
        ResultSet resultset = null;
        Iterator itr = response.getResults().values().iterator();
        if (!itr.hasNext()) {
            throw new DataRecordException("Failed to get source record count from database - Resultset has no records");
        }
        resultset = (ResultSet)itr.next();
        try {
            ResultSetMetaData resultsetMetadata = resultset.getMetaData();
            int batchSize = this.workUnitState.getPropAsInt("source.querybased.fetch.size", 0);
            batchSize = batchSize == 0 ? 1000 : batchSize;
            String sourceConnProps = this.workUnitState.getProp("source.conn.properties");
            boolean convertZeroDateTime = sourceConnProps != null && sourceConnProps.contains("zeroDateTimeBehavior");
            int recordCount = 0;
            while (resultset.next()) {
                int numColumns = resultsetMetadata.getColumnCount();
                JsonObject jsonObject = new JsonObject();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = this.getHeaderRecord().get(i - 1);
                    jsonObject.addProperty(columnName, this.parseColumnAsString(resultset, resultsetMetadata, i, convertZeroDateTime));
                }
                recordSet.add((Object)jsonObject);
                ++this.totalRecordCount;
                if (++recordCount < batchSize) continue;
                this.log.info("Total number of records processed so far: " + this.totalRecordCount);
                return recordSet.iterator();
            }
            this.setNextRecord(false);
            this.log.info("Total number of records processed so far: " + this.totalRecordCount);
            return recordSet.iterator();
        }
        catch (Exception e) {
            throw new DataRecordException("Failed to get records from database; error - " + e.getMessage(), e);
        }
    }

    private String readBlobAsString(Blob logBlob) throws SQLException {
        if (logBlob == null) {
            return "";
        }
        byte[] ba = logBlob.getBytes(1L, (int)logBlob.length());
        if (ba == null) {
            return "";
        }
        String baString = Base64.encodeBase64String((byte[])ba);
        return baString;
    }

    private String readClobAsString(Clob logClob) throws SQLException {
        if (logClob == null) {
            return "";
        }
        long length = logClob.length();
        return logClob.getSubString(1L, (int)length);
    }

    protected boolean convertBitToBoolean() {
        return true;
    }

    private String parseColumnAsString(ResultSet resultset, ResultSetMetaData resultsetMetadata, int i, boolean convertZeroDateTime) throws SQLException {
        if (JdbcExtractor.isBlob(resultsetMetadata.getColumnType(i))) {
            return this.readBlobAsString(resultset.getBlob(i));
        }
        if (JdbcExtractor.isClob(resultsetMetadata.getColumnType(i))) {
            return this.readClobAsString(resultset.getClob(i));
        }
        if ((resultsetMetadata.getColumnType(i) == -7 || resultsetMetadata.getColumnType(i) == 16) && this.convertBitToBoolean()) {
            return Boolean.toString(resultset.getBoolean(i));
        }
        if (convertZeroDateTime && JdbcExtractor.isTimestamp(resultsetMetadata.getColumnType(i))) {
            Timestamp ts = resultset.getTimestamp(i);
            if (ts == null) {
                return null;
            }
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(ts);
        }
        return resultset.getString(i);
    }

    private static boolean isBlob(int columnType) {
        return columnType == -4 || columnType == -2;
    }

    private static boolean isClob(int columnType) {
        return columnType == 2005;
    }

    private static boolean isTimestamp(int columnType) {
        return columnType == 93 || columnType == 2014;
    }

    protected static Command getCommand(String query, JdbcCommand.JdbcCommandType commandType) {
        return new JdbcCommand().build(Arrays.asList(query), commandType);
    }

    protected static Command getCommand(int fetchSize, JdbcCommand.JdbcCommandType commandType) {
        return new JdbcCommand().build(Arrays.asList(Integer.toString(fetchSize)), commandType);
    }

    protected static Command getCommand(List<String> params, JdbcCommand.JdbcCommandType commandType) {
        return new JdbcCommand().build(params, commandType);
    }

    protected String concatPredicates(List<Predicate> predicateList) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (Predicate predicate : predicateList) {
            conditions.add(predicate.getCondition());
        }
        return Joiner.on((String)" and ").skipNulls().join(conditions);
    }

    private JsonObject getDefaultWatermark() {
        String dataType;
        Schema schema = new Schema();
        String columnName = "derivedwatermarkcolumn";
        schema.setColumnName(columnName);
        WatermarkType wmType = WatermarkType.valueOf((String)this.workUnitState.getProp("source.querybased.watermark.type", "TIMESTAMP").toUpperCase());
        switch (wmType) {
            case TIMESTAMP: {
                dataType = "timestamp";
                break;
            }
            case DATE: {
                dataType = "date";
                break;
            }
            default: {
                dataType = "int";
            }
        }
        String elementDataType = "string";
        List mapSymbols = null;
        JsonObject newDataType = this.convertDataType(columnName, dataType, elementDataType, mapSymbols);
        schema.setDataType(newDataType);
        schema.setWaterMark(true);
        schema.setPrimaryKey(0);
        schema.setLength(0L);
        schema.setPrecision(0);
        schema.setScale(0);
        schema.setNullable(false);
        schema.setFormat(null);
        schema.setComment("Default watermark column");
        schema.setDefaultValue(null);
        schema.setUnique(false);
        String jsonStr = gson.toJson((Object)schema);
        JsonObject obj = ((JsonObject)gson.fromJson(jsonStr, JsonObject.class)).getAsJsonObject();
        return obj;
    }

    private Schema getCustomColumnSchema(String columnName) {
        Schema schema = new Schema();
        String dataType = "string";
        schema.setColumnName(columnName);
        String elementDataType = "string";
        List mapSymbols = null;
        JsonObject newDataType = this.convertDataType(columnName, dataType, elementDataType, mapSymbols);
        schema.setDataType(newDataType);
        schema.setWaterMark(false);
        schema.setPrimaryKey(0);
        schema.setLength(0L);
        schema.setPrecision(0);
        schema.setScale(0);
        schema.setNullable(true);
        schema.setFormat(null);
        schema.setComment("Custom column");
        schema.setDefaultValue(null);
        schema.setUnique(false);
        return schema;
    }

    public static boolean hasJoinOperation(String selectQuery) {
        if (selectQuery == null || selectQuery.length() == 0) {
            return false;
        }
        SqlParser sqlParser = SqlParser.create((String)selectQuery);
        try {
            SqlSelect query;
            SqlNode all = sqlParser.parseQuery();
            if (all instanceof SqlSelect) {
                query = (SqlSelect)all;
            } else if (all instanceof SqlOrderBy) {
                query = (SqlSelect)((SqlOrderBy)all).query;
            } else {
                throw new UnsupportedOperationException("The select query is type of " + all.getClass() + " which is not supported here");
            }
            return query.getFrom().getKind() == SqlKind.JOIN;
        }
        catch (SqlParseException e) {
            return false;
        }
    }

    private static RecordSetList<JsonElement> getNewRecordSetList() {
        return new RecordSetList();
    }

    private String toCase(String targetColumnName) {
        String columnName = targetColumnName;
        ColumnNameCase caseType = ColumnNameCase.valueOf((String)this.workUnitState.getProp("source.column.name.case", "NOCHANGE").toUpperCase());
        switch (caseType) {
            case TOUPPER: {
                columnName = targetColumnName.toUpperCase();
                break;
            }
            case TOLOWER: {
                columnName = targetColumnName.toLowerCase();
                break;
            }
            default: {
                columnName = targetColumnName;
            }
        }
        return columnName;
    }

    public String getLeftDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "\"" : "";
    }

    public String getRightDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "\"" : "";
    }

    public void closeConnection() throws Exception {
        if (this.dataConnection != null) {
            try {
                this.dataConnection.close();
            }
            catch (SQLException e) {
                this.log.error("Failed to close connection ;error-" + e.getMessage(), (Throwable)e);
            }
        }
        this.jdbcSource.close();
    }
}

