/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.jdbc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.exception.ExtractPrepareException;
import org.apache.gobblin.source.extractor.extract.QueryBasedSource;
import org.apache.gobblin.source.jdbc.TeradataExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataSource
extends QueryBasedSource<JsonArray, JsonElement> {
    private static final Logger log = LoggerFactory.getLogger(TeradataSource.class);

    public Extractor<JsonArray, JsonElement> getExtractor(WorkUnitState state) throws IOException {
        Extractor extractor = null;
        try {
            extractor = new TeradataExtractor(state).build();
        }
        catch (ExtractPrepareException e) {
            log.error("Failed to prepare extractor: error - {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        return extractor;
    }
}

