/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.jdbc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.exception.ExtractPrepareException;
import org.apache.gobblin.source.extractor.extract.QueryBasedSource;
import org.apache.gobblin.source.jdbc.SqlServerExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerSource
extends QueryBasedSource<JsonArray, JsonElement> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlServerSource.class);

    public Extractor<JsonArray, JsonElement> getExtractor(WorkUnitState state) throws IOException {
        Extractor extractor = null;
        try {
            extractor = new SqlServerExtractor(state).build();
        }
        catch (ExtractPrepareException e) {
            LOG.error("Failed to prepare extractor: error - " + e.getMessage());
            throw new IOException(e);
        }
        return extractor;
    }
}

