/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.jdbc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;
import org.apache.gobblin.metrics.event.lineage.LineageInfo;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.exception.ExtractPrepareException;
import org.apache.gobblin.source.extractor.extract.QueryBasedSource;
import org.apache.gobblin.source.jdbc.MysqlExtractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSource
extends QueryBasedSource<JsonArray, JsonElement> {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlSource.class);

    public Extractor<JsonArray, JsonElement> getExtractor(WorkUnitState state) throws IOException {
        Extractor extractor = null;
        try {
            extractor = new MysqlExtractor(state).build();
        }
        catch (ExtractPrepareException e) {
            LOG.error("Failed to prepare extractor: error - " + e.getMessage());
            throw new IOException(e);
        }
        return extractor;
    }

    protected void addLineageSourceInfo(SourceState sourceState, QueryBasedSource.SourceEntity entity, WorkUnit workUnit) {
        String host = sourceState.getProp("source.conn.host");
        String port = sourceState.getProp("source.conn.port");
        String database = sourceState.getProp("source.querybased.schema");
        String serverUrl = "mysql://" + host.trim() + ":" + port;
        String connectionUrl = "jdbc:" + serverUrl + "/" + database.trim();
        DatasetDescriptor source = new DatasetDescriptor("mysql", URI.create(serverUrl), database + "." + entity.getSourceEntityName());
        source.addMetadata("connectionUrl", connectionUrl);
        if (this.lineageInfo.isPresent()) {
            ((LineageInfo)this.lineageInfo.get()).setSource((Descriptor)source, (State)workUnit);
        }
    }
}

