/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.converter.jdbc.JdbcEntryMetaDatum;
import org.apache.gobblin.converter.jdbc.JdbcType;

public class JdbcEntrySchema
implements Iterable<JdbcEntryMetaDatum> {
    private final Map<String, JdbcEntryMetaDatum> jdbcMetaData;

    public JdbcEntrySchema(Iterable<JdbcEntryMetaDatum> jdbcMetaDatumEntries) {
        Preconditions.checkNotNull(jdbcMetaDatumEntries);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (JdbcEntryMetaDatum datum : jdbcMetaDatumEntries) {
            builder.put((Object)datum.getColumnName(), (Object)datum);
        }
        this.jdbcMetaData = builder.build();
    }

    public JdbcType getJdbcType(String columnName) {
        JdbcEntryMetaDatum datum = this.jdbcMetaData.get(columnName);
        return datum == null ? null : datum.getJdbcType();
    }

    public Set<String> getColumnNames() {
        return this.jdbcMetaData.keySet();
    }

    @Override
    public Iterator<JdbcEntryMetaDatum> iterator() {
        return this.jdbcMetaData.values().iterator();
    }

    public String toString() {
        return "JdbcEntrySchema(jdbcMetaData=" + this.jdbcMetaData + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcEntrySchema)) {
            return false;
        }
        JdbcEntrySchema other = (JdbcEntrySchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, JdbcEntryMetaDatum> this$jdbcMetaData = this.jdbcMetaData;
        Map<String, JdbcEntryMetaDatum> other$jdbcMetaData = other.jdbcMetaData;
        return !(this$jdbcMetaData == null ? other$jdbcMetaData != null : !((Object)this$jdbcMetaData).equals(other$jdbcMetaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcEntrySchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, JdbcEntryMetaDatum> $jdbcMetaData = this.jdbcMetaData;
        result = result * 59 + ($jdbcMetaData == null ? 43 : ((Object)$jdbcMetaData).hashCode());
        return result;
    }
}

