/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.initializer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.initializer.ConverterInitializer;
import org.apache.gobblin.converter.jdbc.JdbcType;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.jdbc.DataSourceBuilder;
import org.apache.gobblin.writer.commands.JdbcWriterCommands;
import org.apache.gobblin.writer.commands.JdbcWriterCommandsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroToJdbcEntryConverterInitializer
implements ConverterInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(AvroToJdbcEntryConverterInitializer.class);
    private final State state;
    private final Collection<WorkUnit> workUnits;
    private final JdbcWriterCommandsFactory jdbcWriterCommandsFactory;
    private final int branches;
    private final int branchId;

    public AvroToJdbcEntryConverterInitializer(State state, Collection<WorkUnit> workUnits) {
        this(state, workUnits, new JdbcWriterCommandsFactory(), 1, 0);
    }

    public AvroToJdbcEntryConverterInitializer(State state, Collection<WorkUnit> workUnits, JdbcWriterCommandsFactory jdbcWriterCommandsFactory, int branches, int branchId) {
        this.state = state;
        this.workUnits = workUnits;
        this.jdbcWriterCommandsFactory = jdbcWriterCommandsFactory;
        this.branches = branches;
        this.branchId = branchId;
    }

    public void initialize() {
        String table = (String)Preconditions.checkNotNull((Object)this.state.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"jdbc.publisher.table_name", (int)this.branches, (int)this.branchId)));
        String db = (String)Preconditions.checkNotNull((Object)this.state.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"jdbc.publisher.database_name", (int)this.branches, (int)this.branchId)));
        try (Connection conn = this.createConnection();){
            JdbcWriterCommands commands = this.jdbcWriterCommandsFactory.newInstance(this.state, conn);
            Map<String, JdbcType> dateColumnMapping = commands.retrieveDateColumns(db, table);
            LOG.info("Date column mapping: " + dateColumnMapping);
            String dateFieldsKey = ForkOperatorUtils.getPropertyNameForBranch((String)"converter.avro.jdbc.date_fields", (int)this.branches, (int)this.branchId);
            for (WorkUnit wu : this.workUnits) {
                wu.setProp(dateFieldsKey, (Object)new Gson().toJson(dateColumnMapping));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    @VisibleForTesting
    public Connection createConnection() throws SQLException {
        DataSource dataSource = DataSourceBuilder.builder().url(this.state.getProp("jdbc.publisher.url")).driver(this.state.getProp("jdbc.publisher.driver")).userName(this.state.getProp("jdbc.publisher.username")).passWord(this.state.getProp("jdbc.publisher.password")).cryptoKeyLocation(this.state.getProp("jdbc.publisher.encrypt_key_loc")).maxActiveConnections(1).state(this.state).build();
        return dataSource.getConnection();
    }
}

