/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public class GsonInterfaceAdapter
implements TypeAdapterFactory {
    protected static final String OBJECT_TYPE = "object-type";
    protected static final String OBJECT_DATA = "object-data";
    private final Class<?> baseClass;

    public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
        if (ClassUtils.isPrimitiveOrWrapper((Class)type.getRawType()) || type.getType() instanceof GenericArrayType || CharSequence.class.isAssignableFrom(type.getRawType()) || type.getType() instanceof ParameterizedType && (Collection.class.isAssignableFrom(type.getRawType()) || Map.class.isAssignableFrom(type.getRawType()))) {
            return null;
        }
        if (!this.baseClass.isAssignableFrom(type.getRawType())) {
            return null;
        }
        InterfaceAdapter<R> adapter = new InterfaceAdapter<R>(gson, this, type);
        return adapter;
    }

    public static <T> Gson getGson(Class<T> clazz) {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonInterfaceAdapter(clazz)).create();
        return gson;
    }

    public GsonInterfaceAdapter(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    private static class InterfaceAdapter<R>
    extends TypeAdapter<R> {
        private final Gson gson;
        private final TypeAdapterFactory factory;
        private final TypeToken<R> typeToken;

        public void write(JsonWriter out, R value) throws IOException {
            if (Optional.class.isAssignableFrom(this.typeToken.getRawType())) {
                Optional opt = (Optional)value;
                if (opt != null && opt.isPresent()) {
                    Object actualValue = opt.get();
                    this.writeObject(actualValue, out);
                } else {
                    out.beginObject();
                    out.endObject();
                }
            } else {
                this.writeObject(value, out);
            }
        }

        public R read(JsonReader in) throws IOException {
            JsonElement element = Streams.parse((JsonReader)in);
            if (element.isJsonNull()) {
                return (R)this.readNull();
            }
            JsonObject jsonObject = element.getAsJsonObject();
            if (this.typeToken.getRawType() == Optional.class) {
                if (jsonObject.has(GsonInterfaceAdapter.OBJECT_TYPE)) {
                    return (R)Optional.of(this.readValue(jsonObject, null));
                }
                if (jsonObject.entrySet().isEmpty()) {
                    return (R)Optional.absent();
                }
                throw new IOException("No class found for Optional value.");
            }
            return this.readValue(jsonObject, this.typeToken);
        }

        private <S> S readNull() {
            if (this.typeToken.getRawType() == Optional.class) {
                return (S)Optional.absent();
            }
            return null;
        }

        private <S> void writeObject(S value, JsonWriter out) throws IOException {
            if (value != null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add(GsonInterfaceAdapter.OBJECT_TYPE, (JsonElement)new JsonPrimitive(value.getClass().getName()));
                TypeAdapter delegate = this.gson.getDelegateAdapter(this.factory, TypeToken.get(value.getClass()));
                jsonObject.add(GsonInterfaceAdapter.OBJECT_DATA, delegate.toJsonTree(value));
                Streams.write((JsonElement)jsonObject, (JsonWriter)out);
            } else {
                out.nullValue();
            }
        }

        private <S> S readValue(JsonObject jsonObject, TypeToken<S> defaultTypeToken) throws IOException {
            try {
                TypeToken actualTypeToken;
                if (jsonObject.isJsonNull()) {
                    return null;
                }
                if (jsonObject.has(GsonInterfaceAdapter.OBJECT_TYPE)) {
                    String className = jsonObject.get(GsonInterfaceAdapter.OBJECT_TYPE).getAsString();
                    Class<?> klazz = Class.forName(className);
                    actualTypeToken = TypeToken.get(klazz);
                } else if (defaultTypeToken != null) {
                    actualTypeToken = defaultTypeToken;
                } else {
                    throw new IOException("Could not determine TypeToken.");
                }
                TypeAdapter delegate = this.gson.getDelegateAdapter(this.factory, actualTypeToken);
                Object value = delegate.fromJsonTree(jsonObject.get(GsonInterfaceAdapter.OBJECT_DATA));
                return (S)value;
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        }

        public InterfaceAdapter(Gson gson, TypeAdapterFactory factory, TypeToken<R> typeToken) {
            this.gson = gson;
            this.factory = factory;
            this.typeToken = typeToken;
        }
    }
}

