/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.WatermarkInterval;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.ImmutableExtract;

public class WorkUnit
extends State {
    private Extract extract;
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Gson GSON = new Gson();

    @Deprecated
    public WorkUnit() {
        this(null, null);
    }

    @Deprecated
    public WorkUnit(SourceState state, Extract extract) {
        if (state != null) {
            super.addAll(state);
        }
        this.extract = extract != null ? extract : new Extract(null, null, null, null);
    }

    @Deprecated
    public WorkUnit(SourceState state, Extract extract, WatermarkInterval watermarkInterval) {
        this(state, extract);
        this.setProp("watermark.interval.value", watermarkInterval.toJson().toString());
    }

    public WorkUnit(Extract extract) {
        this.extract = extract;
    }

    @Deprecated
    public WorkUnit(WorkUnit other) {
        super.addAll(other);
        this.extract = other.getExtract();
    }

    public static WorkUnit createEmpty() {
        return new WorkUnit();
    }

    public static WorkUnit create(Extract extract) {
        return new WorkUnit(null, extract);
    }

    public static WorkUnit create(Extract extract, WatermarkInterval watermarkInterval) {
        return new WorkUnit(null, extract, watermarkInterval);
    }

    public static WorkUnit copyOf(WorkUnit other) {
        return new WorkUnit(other);
    }

    public Extract getExtract() {
        return new ImmutableExtract(this.extract);
    }

    public void skip() {
        this.setProp("workunit.skip", true);
    }

    public JsonElement getLowWatermark() {
        if (!this.contains("watermark.interval.value")) {
            return null;
        }
        return JSON_PARSER.parse(this.getProp("watermark.interval.value")).getAsJsonObject().get("low.watermark.to.json");
    }

    public <T extends Watermark> T getLowWatermark(Class<T> watermarkClass, Gson gson) {
        JsonElement json = this.getLowWatermark();
        if (json == null) {
            return null;
        }
        return (T)((Watermark)gson.fromJson(json, watermarkClass));
    }

    public <T extends Watermark> T getLowWatermark(Class<T> watermarkClass) {
        return this.getLowWatermark(watermarkClass, GSON);
    }

    public JsonElement getExpectedHighWatermark() {
        return JSON_PARSER.parse(this.getProp("watermark.interval.value")).getAsJsonObject().get("expected.watermark.to.json");
    }

    public <T extends Watermark> T getExpectedHighWatermark(Class<T> watermarkClass, Gson gson) {
        JsonElement json = this.getExpectedHighWatermark();
        if (json == null) {
            return null;
        }
        return (T)((Watermark)gson.fromJson(json, watermarkClass));
    }

    public <T extends Watermark> T getExpectedHighWatermark(Class<T> watermarkClass) {
        return this.getExpectedHighWatermark(watermarkClass, GSON);
    }

    @Deprecated
    public long getHighWaterMark() {
        return this.getPropAsLong("workunit.high.water.mark");
    }

    public void setWatermarkInterval(WatermarkInterval watermarkInterval) {
        this.setProp("watermark.interval.value", watermarkInterval.toJson().toString());
    }

    @Deprecated
    public void setHighWaterMark(long highWaterMark) {
        this.setProp("workunit.high.water.mark", highWaterMark);
    }

    @Deprecated
    public long getLowWaterMark() {
        return this.getPropAsLong("workunit.low.water.mark");
    }

    @Override
    public boolean contains(String key) {
        return super.contains(key) || this.extract.contains(key);
    }

    @Override
    public String getProp(String key) {
        return this.getProp(key, null);
    }

    @Override
    public String getProp(String key, String def) {
        String value = super.getProp(key);
        if (value == null) {
            value = this.extract.getProp(key, def);
        }
        return value;
    }

    @Deprecated
    public void setLowWaterMark(long lowWaterMark) {
        this.setProp("workunit.low.water.mark", lowWaterMark);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.extract.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.extract.write(out);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WorkUnit)) {
            return false;
        }
        WorkUnit other = (WorkUnit)object;
        return (this.extract == null && other.extract == null || this.extract != null && this.extract.equals(other.extract)) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extract == null ? 0 : this.extract.hashCode());
        return result;
    }

    public String getOutputFilePath() {
        String namespace = this.getProp("extract.namespace", "");
        String table = this.getProp("extract.table.name", "");
        String extractId = this.getProp("extract.extract.id", "");
        boolean isFull = Boolean.parseBoolean(this.getProp("extract.is.full"));
        return namespace.replaceAll("\\.", "/") + "/" + table + "/" + extractId + "_" + (isFull ? "full" : "append");
    }

    @Override
    public String toString() {
        return "WorkUnit(super=" + super.toString() + ", extract=" + this.getExtract() + ")";
    }
}

