/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import org.apache.gobblin.source.workunit.Extract;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExtractFactory {
    private final Set<Extract> createdInstances = Sets.newHashSet();
    private final DateTimeFormatter dtf;

    public ExtractFactory(String dateTimeFormat) {
        this.dtf = DateTimeFormat.forPattern((String)dateTimeFormat).withLocale(Locale.US).withZone(DateTimeZone.UTC);
    }

    public synchronized Extract getUniqueExtract(Extract.TableType type, String namespace, String table) {
        Extract newExtract = new Extract(type, namespace, table);
        while (this.createdInstances.contains(newExtract)) {
            if (Strings.isNullOrEmpty((String)newExtract.getExtractId())) {
                newExtract.setExtractId(this.dtf.print((ReadableInstant)new DateTime()));
                continue;
            }
            DateTime extractDateTime = this.dtf.parseDateTime(newExtract.getExtractId());
            newExtract.setExtractId(this.dtf.print((ReadableInstant)extractDateTime.plusSeconds(1)));
        }
        this.createdInstances.add(newExtract);
        return newExtract;
    }
}

