/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ack;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.ack.Ackable;

public class HierarchicalAckable
implements Closeable {
    private final List<Ackable> parentAckables;
    private final AtomicInteger remainingCallbacks = new AtomicInteger();
    private final ConcurrentLinkedQueue<Throwable> throwables = new ConcurrentLinkedQueue();
    private volatile boolean closed = false;

    public Ackable newChildAckable() {
        if (this.closed) {
            throw new IllegalStateException(HierarchicalAckable.class.getSimpleName() + " is already closed.");
        }
        this.remainingCallbacks.incrementAndGet();
        return new ChildAckable();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.maybeAck();
    }

    private synchronized void maybeAck() {
        block4: {
            if (this.remainingCallbacks.get() != 0 || !this.closed) break block4;
            if (!this.throwables.isEmpty()) {
                ChildrenFailedException exc = new ChildrenFailedException(ImmutableList.copyOf(this.throwables));
                for (Ackable ackable : this.parentAckables) {
                    ackable.nack(exc);
                }
            } else {
                for (Ackable ackable : this.parentAckables) {
                    ackable.ack();
                }
            }
        }
    }

    public HierarchicalAckable(List<Ackable> parentAckables) {
        this.parentAckables = parentAckables;
    }

    public static class ChildrenFailedException
    extends Exception {
        private final ImmutableList<Throwable> failureCauses;

        private ChildrenFailedException(ImmutableList<Throwable> failureCauses) {
            super("Some child ackables failed.");
            this.failureCauses = failureCauses;
        }

        public ImmutableList<Throwable> getFailureCauses() {
            return this.failureCauses;
        }
    }

    private class ChildAckable
    implements Ackable {
        private volatile boolean acked = false;

        private ChildAckable() {
        }

        @Override
        public synchronized void ack() {
            if (this.acked) {
                return;
            }
            this.acked = true;
            HierarchicalAckable.this.remainingCallbacks.decrementAndGet();
            HierarchicalAckable.this.maybeAck();
        }

        @Override
        public synchronized void nack(Throwable error) {
            if (this.acked) {
                return;
            }
            this.acked = true;
            HierarchicalAckable.this.remainingCallbacks.decrementAndGet();
            HierarchicalAckable.this.throwables.add(error);
            HierarchicalAckable.this.maybeAck();
        }
    }
}

