/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.testing;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertWithBackoff {
    private long timeoutMs = 30000L;
    private Logger log = LoggerFactory.getLogger(AssertWithBackoff.class);
    private Optional<Double> backoffFactor = Optional.absent();
    private Optional<Long> maxSleepMs = Optional.absent();

    public static AssertWithBackoff create() {
        return new AssertWithBackoff();
    }

    public AssertWithBackoff timeoutMs(long assertTimeoutMs) {
        this.timeoutMs = assertTimeoutMs;
        if (!this.maxSleepMs.isPresent()) {
            this.maxSleepMs = Optional.of((Object)this.getAutoMaxSleep());
        }
        if (!this.backoffFactor.isPresent()) {
            this.backoffFactor = Optional.of((Object)this.getAutoBackoffFactor());
        }
        return this;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public AssertWithBackoff maxSleepMs(long maxSleepMs) {
        this.maxSleepMs = Optional.of((Object)maxSleepMs);
        return this;
    }

    public long getMaxSleepMs() {
        return (Long)this.maxSleepMs.or((Object)this.getAutoMaxSleep());
    }

    public AssertWithBackoff backoffFactor(double backoffFactor) {
        this.backoffFactor = Optional.of((Object)backoffFactor);
        return this;
    }

    public double getBackoffFactor() {
        return (Double)this.backoffFactor.or((Object)this.getAutoBackoffFactor());
    }

    public AssertWithBackoff logger(Logger log) {
        this.log = log;
        return this;
    }

    public Logger getLogger() {
        return this.log;
    }

    private long getAutoMaxSleep() {
        return this.timeoutMs / 3L;
    }

    private double getAutoBackoffFactor() {
        return Math.log(this.getMaxSleepMs()) / Math.log(5.0);
    }

    public void assertTrue(Predicate<Void> condition, String message) throws TimeoutException, InterruptedException {
        AssertWithBackoff.assertTrue(condition, this.getTimeoutMs(), message, this.getLogger(), this.getBackoffFactor(), this.getMaxSleepMs());
    }

    public <T> void assertEquals(Function<Void, T> actual, T expected, String message) throws TimeoutException, InterruptedException {
        this.assertTrue(new EqualsCheck<T>(actual, expected, message), message);
    }

    public static void assertTrue(Predicate<Void> condition, long assertTimeoutMs, String message, Logger log, double backoffFactor, long maxSleepMs) throws TimeoutException, InterruptedException {
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + assertTimeoutMs;
        long currentSleepMs = 0L;
        boolean done = false;
        try {
            while (!done && System.currentTimeMillis() < endTimeMs) {
                done = condition.apply(null);
                if (done) continue;
                currentSleepMs = AssertWithBackoff.computeRetrySleep(currentSleepMs, backoffFactor, maxSleepMs, endTimeMs);
                log.debug("Condition check for '" + message + "' failed; sleeping for " + currentSleepMs + "ms");
                Thread.sleep(currentSleepMs);
            }
            if (!done && !condition.apply(null)) {
                throw new TimeoutException("Timeout waiting for condition '" + message + "'.");
            }
        }
        catch (InterruptedException | TimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Exception checking condition '" + message + "':" + e, e);
        }
    }

    public static long computeRetrySleep(long currentSleepMs, double backoffFactor, long maxSleepMs, long endTimeMs) {
        long newSleepMs = Math.round((double)currentSleepMs * backoffFactor);
        if (newSleepMs <= currentSleepMs) {
            newSleepMs = currentSleepMs + 1L;
        }
        long currentTimeMs = System.currentTimeMillis();
        newSleepMs = Math.min(Math.min(newSleepMs, maxSleepMs), endTimeMs - currentTimeMs);
        return newSleepMs;
    }

    public class EqualsCheck<T>
    implements Predicate<Void> {
        private final Predicate<T> eqToExpected;
        private final String message;
        private final Function<Void, T> actual;

        public EqualsCheck(Function<Void, T> actual, T expected, String message) {
            this.eqToExpected = Predicates.equalTo(expected);
            this.message = message;
            this.actual = actual;
        }

        public boolean apply(Void input) {
            Object currentValue = this.actual.apply((Object)input);
            AssertWithBackoff.this.getLogger().debug("checking '" + this.message + "': " + currentValue);
            return this.eqToExpected.apply(currentValue);
        }
    }
}

