/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.records;

import io.reactivex.Flowable;
import java.util.function.Function;
import org.apache.gobblin.metadata.GlobalMetadata;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.stream.StreamEntity;

public class RecordStreamWithMetadata<D, S> {
    private final Flowable<StreamEntity<D>> recordStream;
    private final GlobalMetadata<S> globalMetadata;

    public <DO> RecordStreamWithMetadata<DO, S> withRecordStream(Flowable<StreamEntity<DO>> newRecordStream) {
        return this.withRecordStream(newRecordStream, this.globalMetadata);
    }

    @Deprecated
    public <DO, SO> RecordStreamWithMetadata<DO, SO> withRecordStream(Flowable<StreamEntity<DO>> newRecordStream, SO newSchema) {
        return new RecordStreamWithMetadata(newRecordStream, GlobalMetadata.builder().schema(newSchema).build());
    }

    public <DO, SO> RecordStreamWithMetadata<DO, SO> withRecordStream(Flowable<StreamEntity<DO>> newRecordStream, GlobalMetadata<SO> newGlobalMetadata) {
        return new RecordStreamWithMetadata<DO, SO>(newRecordStream, newGlobalMetadata);
    }

    public <DO> RecordStreamWithMetadata<DO, S> mapStream(Function<? super Flowable<StreamEntity<D>>, ? extends Flowable<StreamEntity<DO>>> transform) {
        return new RecordStreamWithMetadata<DO, S>(transform.apply(this.recordStream), this.globalMetadata);
    }

    public <DO> RecordStreamWithMetadata<DO, S> mapRecords(Function<RecordEnvelope<D>, RecordEnvelope<DO>> transform) {
        return this.withRecordStream(this.recordStream.map(entity -> {
            if (entity instanceof RecordEnvelope) {
                return (StreamEntity)transform.apply((RecordEnvelope)entity);
            }
            return entity;
        }));
    }

    public RecordStreamWithMetadata(Flowable<StreamEntity<D>> recordStream, GlobalMetadata<S> globalMetadata) {
        this.recordStream = recordStream;
        this.globalMetadata = globalMetadata;
    }

    public Flowable<StreamEntity<D>> getRecordStream() {
        return this.recordStream;
    }

    public GlobalMetadata<S> getGlobalMetadata() {
        return this.globalMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordStreamWithMetadata)) {
            return false;
        }
        RecordStreamWithMetadata other = (RecordStreamWithMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Flowable<StreamEntity<D>> this$recordStream = this.getRecordStream();
        Flowable<StreamEntity<D>> other$recordStream = other.getRecordStream();
        if (this$recordStream == null ? other$recordStream != null : !this$recordStream.equals(other$recordStream)) {
            return false;
        }
        GlobalMetadata<S> this$globalMetadata = this.getGlobalMetadata();
        GlobalMetadata<S> other$globalMetadata = other.getGlobalMetadata();
        return !(this$globalMetadata == null ? other$globalMetadata != null : !((Object)this$globalMetadata).equals(other$globalMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordStreamWithMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Flowable<StreamEntity<D>> $recordStream = this.getRecordStream();
        result = result * 59 + ($recordStream == null ? 43 : $recordStream.hashCode());
        GlobalMetadata<S> $globalMetadata = this.getGlobalMetadata();
        result = result * 59 + ($globalMetadata == null ? 43 : ((Object)$globalMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "RecordStreamWithMetadata(recordStream=" + this.getRecordStream() + ", globalMetadata=" + this.getGlobalMetadata() + ")";
    }
}

