/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.util.Collection;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.fs.Path;

public abstract class RecordCountProvider {
    public abstract long getRecordCount(Path var1);

    public Path convertPath(Path path, String extension, RecordCountProvider src) {
        if (this.getClass().equals(src.getClass())) {
            return path;
        }
        throw this.getNotImplementedException(src);
    }

    protected NotImplementedException getNotImplementedException(RecordCountProvider src) {
        return new NotImplementedException(String.format("converting from %s to %s is not implemented", src.getClass().getName(), this.getClass().getName()));
    }

    public long getRecordCount(Collection<Path> paths) {
        long count = 0L;
        for (Path path : paths) {
            count += this.getRecordCount(path);
        }
        return count;
    }
}

