/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metadata;

import com.google.common.base.Optional;
import org.apache.gobblin.fork.CopyHelper;
import org.apache.gobblin.fork.CopyNotSupportedException;
import org.apache.gobblin.fork.Copyable;

public class GlobalMetadata<S>
implements Copyable<GlobalMetadata<S>> {
    private S schema;

    @Override
    public GlobalMetadata<S> copy() throws CopyNotSupportedException {
        if (CopyHelper.isCopyable(this.schema)) {
            return new GlobalMetadata<Object>(CopyHelper.copy(this.schema));
        }
        throw new CopyNotSupportedException("Type is not copyable: " + this.schema.getClass().getName());
    }

    public static <SI, SO> GlobalMetadataBuilder<SO> builderWithInput(GlobalMetadata<SI> inputMetadata, Optional<SO> outputSchema) {
        GlobalMetadataBuilder<Object> builder = GlobalMetadata.builder();
        if (outputSchema.isPresent()) {
            builder.schema(outputSchema.get());
        }
        return builder;
    }

    public static <S> GlobalMetadataBuilder<S> builder() {
        return new GlobalMetadataBuilder();
    }

    private GlobalMetadata(S schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalMetadata)) {
            return false;
        }
        GlobalMetadata other = (GlobalMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        S this$schema = this.getSchema();
        S other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    public S getSchema() {
        return this.schema;
    }

    public static class GlobalMetadataBuilder<S> {
        private S schema;

        GlobalMetadataBuilder() {
        }

        public GlobalMetadataBuilder<S> schema(S schema) {
            this.schema = schema;
            return this;
        }

        public GlobalMetadata<S> build() {
            return new GlobalMetadata(this.schema);
        }

        public String toString() {
            return "GlobalMetadata.GlobalMetadataBuilder(schema=" + this.schema + ")";
        }
    }
}

