/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.gobblin.compat.hadoop.TextSerializer;
import org.apache.gobblin.compat.hadoop.WritableShim;

public class State
implements WritableShim {
    private static final Joiner LIST_JOINER = Joiner.on((String)",");
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private String id;
    private Properties commonProperties;
    private Properties specProperties;
    private final JsonParser jsonParser = new JsonParser();

    public State() {
        this.specProperties = new Properties();
        this.commonProperties = new Properties();
    }

    public State(Properties properties) {
        this.specProperties = properties;
        this.commonProperties = new Properties();
    }

    public State(State otherState) {
        this.commonProperties = otherState.getCommonProperties();
        this.specProperties = new Properties();
        this.specProperties.putAll((Map<?, ?>)otherState.getProperties());
        for (Object key : this.commonProperties.keySet()) {
            if (!this.specProperties.containsKey(key) || !this.commonProperties.get(key).equals(this.specProperties.get(key))) continue;
            this.specProperties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        Properties properties = this.specProperties;
        synchronized (properties) {
            Properties props = new Properties();
            if (this.commonProperties != null) {
                props.putAll((Map<?, ?>)this.commonProperties);
            }
            props.putAll((Map<?, ?>)this.specProperties);
            return props;
        }
    }

    public void addAll(State otherState) {
        Properties diffCommonProps = new Properties();
        diffCommonProps.putAll((Map<?, ?>)Maps.difference((Map)this.commonProperties, (Map)otherState.commonProperties).entriesOnlyOnRight());
        this.addAll(diffCommonProps);
        this.addAll(otherState.specProperties);
    }

    public void addAll(Properties properties) {
        this.specProperties.putAll((Map<?, ?>)properties);
    }

    public void addAllIfNotExist(State otherState) {
        this.addAllIfNotExist(otherState.commonProperties);
        this.addAllIfNotExist(otherState.specProperties);
    }

    public void addAllIfNotExist(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            if (this.specProperties.containsKey(key) || this.commonProperties.containsKey(key)) continue;
            this.specProperties.setProperty(key, properties.getProperty(key));
        }
    }

    public void overrideWith(State otherState) {
        this.overrideWith(otherState.commonProperties);
        this.overrideWith(otherState.specProperties);
    }

    public void overrideWith(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            if (!this.specProperties.containsKey(key) && !this.commonProperties.containsKey(key)) continue;
            this.specProperties.setProperty(key, properties.getProperty(key));
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProp(String key, Object value) {
        this.specProperties.put(key, value.toString());
    }

    public void setProps(Properties commonProperties, Properties specProperties) {
        this.commonProperties = commonProperties;
        this.specProperties = specProperties;
    }

    public synchronized void appendToListProp(String key, String value) {
        if (this.contains(key)) {
            this.setProp(key, LIST_JOINER.join((Object)this.getProp(key), (Object)value, new Object[0]));
        } else {
            this.setProp(key, value);
        }
    }

    public synchronized void appendToSetProp(String key, String value) {
        HashSet set;
        HashSet hashSet = set = value == null ? Sets.newHashSet() : Sets.newHashSet((Iterable)LIST_SPLITTER.splitToList((CharSequence)value));
        if (this.contains(key)) {
            set.addAll(this.getPropAsSet(key));
        }
        this.setProp(key, LIST_JOINER.join((Iterable)set));
    }

    public String getProp(String key) {
        if (this.specProperties.containsKey(key)) {
            return this.specProperties.getProperty(key);
        }
        return this.commonProperties.getProperty(key);
    }

    public String getProp(String key, String def) {
        if (this.specProperties.containsKey(key)) {
            return this.specProperties.getProperty(key);
        }
        return this.commonProperties.getProperty(key, def);
    }

    public List<String> getPropAsList(String key) {
        return LIST_SPLITTER.splitToList((CharSequence)this.getProp(key));
    }

    public List<String> getPropAsList(String key, String def) {
        return LIST_SPLITTER.splitToList((CharSequence)this.getProp(key, def));
    }

    public Set<String> getPropAsSet(String key) {
        return ImmutableSet.copyOf((Collection)LIST_SPLITTER.splitToList((CharSequence)this.getProp(key)));
    }

    public Set<String> getPropAsSet(String key, String def) {
        return ImmutableSet.copyOf((Collection)LIST_SPLITTER.splitToList((CharSequence)this.getProp(key, def)));
    }

    public Set<String> getPropAsCaseInsensitiveSet(String key) {
        return ImmutableSortedSet.copyOf((Comparator)String.CASE_INSENSITIVE_ORDER, (Iterable)LIST_SPLITTER.split((CharSequence)this.getProp(key)));
    }

    public Set<String> getPropAsCaseInsensitiveSet(String key, String def) {
        return ImmutableSortedSet.copyOf((Comparator)String.CASE_INSENSITIVE_ORDER, (Iterable)LIST_SPLITTER.split((CharSequence)this.getProp(key, def)));
    }

    public long getPropAsLong(String key) {
        return Long.parseLong(this.getProp(key));
    }

    public long getPropAsLong(String key, long def) {
        return Long.parseLong(this.getProp(key, String.valueOf(def)));
    }

    public int getPropAsInt(String key) {
        return Integer.parseInt(this.getProp(key));
    }

    public int getPropAsInt(String key, int def) {
        return Integer.parseInt(this.getProp(key, String.valueOf(def)));
    }

    public short getPropAsShort(String key) {
        return Short.parseShort(this.getProp(key));
    }

    public short getPropAsShortWithRadix(String key, int radix) {
        return Short.parseShort(this.getProp(key), radix);
    }

    public short getPropAsShort(String key, short def) {
        return Short.parseShort(this.getProp(key, String.valueOf(def)));
    }

    public short getPropAsShortWithRadix(String key, short def, int radix) {
        return this.contains(key) ? Short.parseShort(this.getProp(key), radix) : def;
    }

    public double getPropAsDouble(String key) {
        return Double.parseDouble(this.getProp(key));
    }

    public double getPropAsDouble(String key, double def) {
        return Double.parseDouble(this.getProp(key, String.valueOf(def)));
    }

    public boolean getPropAsBoolean(String key) {
        return Boolean.parseBoolean(this.getProp(key));
    }

    public boolean getPropAsBoolean(String key, boolean def) {
        return Boolean.parseBoolean(this.getProp(key, String.valueOf(def)));
    }

    public JsonArray getPropAsJsonArray(String key) {
        JsonElement jsonElement = this.jsonParser.parse(this.getProp(key));
        Preconditions.checkArgument((boolean)jsonElement.isJsonArray(), (Object)("Value for key " + key + " is malformed, it must be a JsonArray: " + jsonElement));
        return jsonElement.getAsJsonArray();
    }

    public void removeProp(String key) {
        this.specProperties.remove(key);
        if (this.commonProperties.containsKey(key)) {
            Properties commonPropsCopy = new Properties();
            commonPropsCopy.putAll((Map<?, ?>)this.commonProperties);
            commonPropsCopy.remove(key);
            this.commonProperties = commonPropsCopy;
        }
    }

    public void removePropsWithPrefix(String prefix) {
        this.specProperties.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(prefix));
        Properties newCommonProperties = null;
        for (Object key : this.commonProperties.keySet()) {
            if (!((String)key).startsWith(prefix)) continue;
            if (newCommonProperties == null) {
                newCommonProperties = new Properties();
                newCommonProperties.putAll((Map<?, ?>)this.commonProperties);
            }
            newCommonProperties.remove(key);
        }
        if (newCommonProperties != null) {
            this.commonProperties = newCommonProperties;
        }
    }

    @Deprecated
    protected String getProperty(String key) {
        return this.getProp(key);
    }

    @Deprecated
    protected String getProperty(String key, String def) {
        return this.getProp(key, def);
    }

    public Set<String> getPropertyNames() {
        return Sets.newHashSet((Iterable)Iterables.concat(this.commonProperties.stringPropertyNames(), this.specProperties.stringPropertyNames()));
    }

    public boolean contains(String key) {
        return this.specProperties.containsKey(key) || this.commonProperties.containsKey(key);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int numEntries = in.readInt();
        while (numEntries-- > 0) {
            String key = TextSerializer.readTextAsString(in).intern();
            String value = TextSerializer.readTextAsString(in).intern();
            this.specProperties.put(key, value);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.commonProperties.size() + this.specProperties.size());
        for (Object key : this.commonProperties.keySet()) {
            TextSerializer.writeStringAsText(out, (String)key);
            TextSerializer.writeStringAsText(out, this.commonProperties.getProperty((String)key));
        }
        for (Object key : this.specProperties.keySet()) {
            TextSerializer.writeStringAsText(out, (String)key);
            TextSerializer.writeStringAsText(out, this.specProperties.getProperty((String)key));
        }
    }

    public String toString() {
        return "Common:" + this.commonProperties.toString() + "\n Specific: " + this.specProperties.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Properties this$commonProperties = this.getCommonProperties();
        Properties other$commonProperties = other.getCommonProperties();
        if (this$commonProperties == null ? other$commonProperties != null : !((Object)this$commonProperties).equals(other$commonProperties)) {
            return false;
        }
        Properties this$specProperties = this.getSpecProperties();
        Properties other$specProperties = other.getSpecProperties();
        return !(this$specProperties == null ? other$specProperties != null : !((Object)this$specProperties).equals(other$specProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof State;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Properties $commonProperties = this.getCommonProperties();
        result = result * 59 + ($commonProperties == null ? 43 : ((Object)$commonProperties).hashCode());
        Properties $specProperties = this.getSpecProperties();
        result = result * 59 + ($specProperties == null ? 43 : ((Object)$specProperties).hashCode());
        return result;
    }

    public Properties getCommonProperties() {
        return this.commonProperties;
    }

    public Properties getSpecProperties() {
        return this.specProperties;
    }
}

