/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.reporting;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.mavenplugins.geronimo.reporting.Reportable;
import org.apache.geronimo.mavenplugins.geronimo.reporting.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class SurefireReporter
implements Reporter {
    private static final Log log = LogFactory.getLog(SurefireReporter.class);
    private static final String LS = System.getProperty("line.separator");
    private String testName;
    private File logFile;
    private Throwable failureCause;
    private File reportsDirectory = null;
    private File outputFile;
    private File reportFile;
    private long startTime;
    private int numErrors = 0;
    private static final int MS_PER_SEC = 1000;
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private List results = Collections.synchronizedList(new ArrayList());

    public void reportBegin(Reportable source) {
        assert (source != null);
        this.logFile = source.getLogFile();
        this.testName = source.getName();
        this.startTime = source.getStartTime().getTime();
        try {
            FileUtils.forceMkdir((File)this.reportsDirectory);
        }
        catch (IOException e) {
            log.error((Object)("Failed to make reports directory: " + this.reportsDirectory), (Throwable)e);
        }
        this.outputFile = new File(this.reportsDirectory, this.testName + ".txt");
        this.reportFile = new File(this.reportsDirectory, "TEST-" + this.testName + ".xml");
        if (this.reportFile.exists()) {
            this.reportFile.delete();
        }
    }

    public void reportError(Throwable cause) {
        assert (cause != null);
        log.debug((Object)"Capturing failed report from cause", cause);
        this.failureCause = cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportEnd() {
        try {
            if (this.logFile.exists()) {
                FileUtils.copyFile((File)this.logFile, (File)this.outputFile);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to update outputFile", (Throwable)e);
        }
        if (this.failureCause != null) {
            try {
                boolean append = this.outputFile.exists();
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile, append)));
                try {
                    writer.println("Exception Detail");
                    writer.println("================");
                    this.failureCause.printStackTrace(writer);
                    writer.flush();
                }
                finally {
                    writer.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Failed to append error detail to outputFile", (Throwable)e);
            }
            this.testFailed();
        } else {
            this.testSucceeded();
        }
        try {
            this.testSetCompleted();
        }
        catch (ReporterException e) {
            log.warn((Object)"Failed to set test completed", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testSetCompleted() throws ReporterException {
        long runTime = System.currentTimeMillis() - this.startTime;
        Xpp3Dom testSuite = this.createTestElement("testsuite", this.testName, runTime);
        this.showProperties(testSuite);
        testSuite.setAttribute("tests", "1");
        testSuite.setAttribute("errors", String.valueOf(this.numErrors));
        testSuite.setAttribute("skipped", "0");
        testSuite.setAttribute("failures", "0");
        for (Xpp3Dom testcase : this.results) {
            testSuite.addChild(testcase);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + LS);
            Xpp3DomWriter.write((XMLWriter)new PrettyPrintXMLWriter(writer), (Xpp3Dom)testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ReporterException("Unable to use UTF-8 encoding", (Exception)e);
                catch (FileNotFoundException e2) {
                    throw new ReporterException("Unable to create file: " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private Xpp3Dom createTestElement(String element, String testName, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom(element);
        testCase.setAttribute("name", testName);
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    private Xpp3Dom createElement(Xpp3Dom element, String testName) {
        Xpp3Dom component = new Xpp3Dom(testName);
        element.addChild(component);
        return component;
    }

    private void testSucceeded() {
        long runTime = System.currentTimeMillis() - this.startTime;
        Xpp3Dom testCase = this.createTestElement("testcase", this.testName, runTime);
        this.results.add(testCase);
    }

    private void testFailed() {
        ++this.numErrors;
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.outputFile));
            int length = ((InputStream)input).available();
            byte[] b = new byte[length];
            ((InputStream)input).read(b, 0, length);
            this.writeTestProblems(this.testName, new String(b));
        }
        catch (IOException e) {
            log.error((Object)"Failed to write test problems", (Throwable)e);
        }
    }

    private void writeTestProblems(String testName, String stdErr) {
        long runTime = System.currentTimeMillis() - this.startTime;
        Xpp3Dom testCase = this.createTestElement("testcase", testName, runTime);
        Xpp3Dom element = this.createElement(testCase, "failure");
        element.setAttribute("message", SurefireReporter.escapeAttribute(this.getMessage(stdErr)));
        element.setAttribute("type", this.getType(stdErr));
        element.setValue(stdErr);
        this.results.add(testCase);
    }

    private void showProperties(Xpp3Dom testSuite) {
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", SurefireReporter.escapeAttribute(value));
            }
        }
    }

    private static String escapeAttribute(String attribute) {
        String s = StringUtils.replace((String)attribute, (String)"<", (String)"&lt;");
        return StringUtils.replace((String)s, (String)">", (String)"&gt;");
    }

    private Iterator getResults() {
        return this.results.iterator();
    }

    private String elapsedTimeAsString(long runTime) {
        return this.numberFormat.format((double)runTime / 1000.0);
    }

    private String getMessage(String stdErr) {
        int beginMarker = stdErr.indexOf("Exception:") + 10;
        int endMarker = stdErr.indexOf("\n", beginMarker);
        return stdErr.substring(beginMarker, endMarker);
    }

    private String getType(String stdErr) {
        int endMarker = stdErr.indexOf("Exception:") + 9;
        int beginMarker = stdErr.lastIndexOf("\n", endMarker) + 1;
        return stdErr.substring(beginMarker, endMarker);
    }

    public File getReportsFile() {
        return this.reportFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

