/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.module;

import java.io.File;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.mavenplugins.geronimo.ModuleConfig;
import org.apache.geronimo.mavenplugins.geronimo.module.ModuleMojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class DeployModuleMojo
extends ModuleMojoSupport {
    protected File moduleArchive = null;
    private File modulePlan = null;
    private boolean startModules = false;

    protected void doExecute() throws Exception {
        ArrayList<TargetModuleID[]> completed = new ArrayList<TargetModuleID[]>();
        if (this.moduleArchive != null || this.modulePlan != null) {
            this.log.info((CharSequence)("Using non-artifact based module archive: " + this.moduleArchive));
            this.log.info((CharSequence)("Using non-artifact based plan: " + this.modulePlan));
            TargetModuleID[] ids = this.distribute(this.moduleArchive, this.modulePlan);
            completed.add(ids);
        } else if (this.modules == null || this.modules.length == 0) {
            throw new MojoExecutionException("At least one module configuration (or moduleArchive) must be specified");
        }
        if (this.modules != null && this.modules.length != 0) {
            this.log.info((CharSequence)"Using artifact based module archive(s)...");
            for (int i = 0; i < this.modules.length; ++i) {
                TargetModuleID[] ids = this.distribute(this.getModuleArchive(this.modules[i]), this.modules[i].getPlan());
                completed.add(ids);
            }
        }
        if (this.startModules) {
            this.log.info((CharSequence)"Starting modules...");
            for (TargetModuleID[] moduleIds : completed) {
                for (int i = 0; i < moduleIds.length; ++i) {
                    String url = moduleIds[i].getWebURL();
                    this.log.info((CharSequence)("Starting module: " + moduleIds[i].getModuleID() + (url == null ? "" : "; URL: " + url)));
                }
                ProgressObject progress = this.getDeploymentManager().start(moduleIds);
                DeploymentStatus status = this.waitFor(progress);
                if (status.isFailed()) {
                    throw new MojoExecutionException("Failed to start modules: " + status.getMessage());
                }
                this.log.info((CharSequence)"Started module(s):");
                this.logModules(moduleIds, "    ");
            }
        }
    }

    private File getModuleArchive(ModuleConfig module) throws MojoExecutionException {
        Artifact artifact = this.getArtifact(module);
        File file = artifact.getFile();
        if (file == null) {
            throw new MojoExecutionException("Module artifact does not have an attached file: " + (Object)((Object)module));
        }
        String type = artifact.getType();
        this.log.debug((CharSequence)("Artifact file is: " + file + " (" + type + ")"));
        if (!("war".equals(type) || "ear".equals(type) || "rar".equals(type) || "jar".equals(type))) {
            throw new MojoExecutionException("Module does not look like a JavaEE archive: " + (Object)((Object)module));
        }
        return file;
    }

    private TargetModuleID[] distribute(File file, File plan) throws Exception {
        this.log.info((CharSequence)("Distributing module artifact: " + file + " with plan " + plan));
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        ProgressObject progress = manager.distribute(targets, file, plan);
        DeploymentStatus status = this.waitFor(progress);
        if (status.isFailed()) {
            if (status.getMessage().indexOf("already exists") < 0) {
                throw new MojoExecutionException("Distribution failed: " + status.getMessage());
            }
            this.log.info((CharSequence)"Module already exists");
        }
        return progress != null ? progress.getResultTargetModuleIDs() : null;
    }

    protected String getFullClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

