/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;

public class ServerProxy {
    private static final Log log = LogFactory.getLog(ServerProxy.class);
    private JMXServiceURL url;
    private Map environment;
    private MBeanServerConnection mbeanConnection;
    private Throwable lastError;

    public ServerProxy(JMXServiceURL url, Map environment) throws Exception {
        this.init(url, environment);
    }

    public ServerProxy(String hostname, int port, String username, String password) throws Exception {
        this("service:jmx:rmi://" + hostname + "/jndi/rmi://" + hostname + ":" + port + "/JMXConnector", username, password);
    }

    public ServerProxy(String url, String username, String password) throws Exception {
        assert (url != null);
        assert (username != null);
        assert (password != null);
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{username, password});
        this.init(new JMXServiceURL(url), env);
    }

    private void init(JMXServiceURL url, Map environment) throws Exception {
        assert (url != null);
        assert (environment != null);
        this.url = url;
        this.environment = new HashMap();
        this.environment.put("jmx.remote.credentials", new String[]{"system", "manager"});
        log.debug((Object)("Initialized with URL: " + url + ", environment: " + environment));
    }

    private MBeanServerConnection getConnection() throws IOException {
        if (this.mbeanConnection == null) {
            log.debug((Object)("Connecting to: " + this.url));
            JMXConnector connector = JMXConnectorFactory.connect(this.url, this.environment);
            this.mbeanConnection = connector.getMBeanServerConnection();
            log.debug((Object)"Connected");
        }
        return this.mbeanConnection;
    }

    public boolean isFullyStarted() {
        boolean fullyStarted = true;
        try {
            AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
            Set result = this.listGBeans(query);
            for (AbstractName name : result) {
                boolean started = this.getBooleanAttribute(name, "kernelFullyStarted");
                if (started) continue;
                fullyStarted = false;
                break;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Connection failure; ignoring", (Throwable)e);
            fullyStarted = false;
            this.lastError = e;
        }
        catch (Exception e) {
            log.debug((Object)"Unable to determine if the server is fully started", (Throwable)e);
            fullyStarted = false;
            this.lastError = e;
        }
        return fullyStarted;
    }

    public String getGeronimoHome() {
        String home = null;
        try {
            ObjectName systemInfoQuery = new ObjectName("*:name=ServerInfo,j2eeType=GBean,*");
            this.getConnection();
            Set<ObjectName> set = this.mbeanConnection.queryNames(systemInfoQuery, null);
            if (set.size() > 0) {
                ObjectName found = set.iterator().next();
                home = (String)this.mbeanConnection.getAttribute(found, "currentBaseDirectory");
            }
        }
        catch (IOException e) {
            log.debug((Object)"Connection failure; ignoring", (Throwable)e);
            this.lastError = e;
        }
        catch (Exception e) {
            log.debug((Object)"Unable to determine if the server home directory", (Throwable)e);
            this.lastError = e;
        }
        return home;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void shutdown() {
        try {
            this.invoke("shutdown");
        }
        catch (Exception e) {
            log.warn((Object)"Unable to shutdown the server", (Throwable)e);
            this.lastError = e;
        }
    }

    private Object invoke(String operation, Object[] args, String[] signature) throws Exception {
        assert (operation != null);
        assert (args != null);
        assert (signature != null);
        return this.getConnection().invoke(Kernel.KERNEL, operation, args, signature);
    }

    private Object invoke(String operation, Object[] args) throws Exception {
        assert (args != null);
        String[] signature = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            signature[i] = args[i].getClass().getName();
        }
        return this.invoke(operation, args, signature);
    }

    private Object invoke(String operation) throws Exception {
        return this.invoke(operation, new Object[0]);
    }

    private Set listGBeans(AbstractNameQuery query) throws Exception {
        return (Set)this.invoke("listGBeans", new Object[]{query});
    }

    private Object getAttribute(AbstractName name, String attribute) throws Exception {
        assert (name != null);
        assert (attribute != null);
        return this.invoke("getAttribute", new Object[]{name, attribute});
    }

    private boolean getBooleanAttribute(AbstractName name, String attribute) throws Exception {
        Object obj = this.getAttribute(name, attribute);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new RuntimeException("Attribute is not of type Boolean: " + attribute);
    }
}

