/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.saaj;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAAJUniverse {
    private static final Logger LOG = LoggerFactory.getLogger(SAAJUniverse.class);
    public static final Type DEFAULT = Type.DEFAULT;
    public static final Type SUN = Type.SUN;
    public static final Type AXIS1 = Type.AXIS1;
    public static final Type AXIS2 = Type.AXIS2;
    private static final ThreadLocal<LinkedList<Type>> currentUniverse = new InheritableThreadLocal<LinkedList<Type>>();

    public void set(Type newUniverse) {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList == null) {
            universeList = new LinkedList();
            currentUniverse.set(universeList);
        }
        universeList.add(newUniverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set universe: " + Thread.currentThread() + " " + (Object)((Object)newUniverse));
        }
    }

    public void unset() {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList != null && !universeList.isEmpty()) {
            universeList.removeLast();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Restored universe: " + Thread.currentThread());
            }
        }
    }

    static Type getCurrentUniverse() {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList != null && !universeList.isEmpty()) {
            return universeList.getLast();
        }
        return null;
    }

    static enum Type {
        DEFAULT,
        AXIS1,
        AXIS2,
        SUN;

    }
}

