/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.saaj;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.webservices.saaj.SAAJUniverse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAAJFactoryFinder {
    private static final Log LOG = LogFactory.getLog(SAAJFactoryFinder.class);
    private static final String SAAJ_PROVIDER_PROPERTY = "org.apache.geronimo.saaj.provider";
    private static final Map<String, Map<String, String>> SAAJ_FACTORIES = new HashMap<String, Map<String, String>>();
    private static SAAJUniverse.Type DEFAULT_SAAJ_UNIVERSE = null;

    SAAJFactoryFinder() {
    }

    private static void initDefaultSAAJProvider() {
        String provider = System.getProperty(SAAJ_PROVIDER_PROPERTY);
        if (provider != null) {
            if (provider.equalsIgnoreCase("axis2")) {
                DEFAULT_SAAJ_UNIVERSE = SAAJUniverse.Type.AXIS2;
            } else if (provider.equalsIgnoreCase("sun")) {
                DEFAULT_SAAJ_UNIVERSE = SAAJUniverse.Type.SUN;
            } else {
                throw new RuntimeException("Invalid SAAJ universe specified: " + provider);
            }
            LOG.info((Object)("Default SAAJ universe: " + (Object)((Object)DEFAULT_SAAJ_UNIVERSE)));
        } else {
            LOG.info((Object)"Default SAAJ universe not set");
        }
    }

    private static Map<String, String> createSAAJInfo(String messageFactory, String soapFactory, String soapConnectionFactory, String metaFactory) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.xml.soap.MessageFactory", messageFactory);
        map.put("javax.xml.soap.SOAPFactory", soapFactory);
        map.put("javax.xml.soap.SOAPConnectionFactory", soapConnectionFactory);
        map.put("javax.xml.soap.MetaFactory", metaFactory);
        return map;
    }

    static Object find(String factoryPropertyName) throws SOAPException {
        String factoryClassName = SAAJFactoryFinder.getFactoryClass(factoryPropertyName);
        if (factoryClassName == null) {
            throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
        }
        return SAAJFactoryFinder.newInstance(factoryClassName);
    }

    private static String getFactoryClass(String factoryName) {
        SAAJUniverse.Type universe = SAAJUniverse.getCurrentUniverse();
        if (universe == null || universe == SAAJUniverse.Type.DEFAULT) {
            universe = DEFAULT_SAAJ_UNIVERSE == null ? (SAAJFactoryFinder.isAxis2InClassLoader() ? SAAJUniverse.Type.AXIS2 : SAAJUniverse.Type.SUN) : DEFAULT_SAAJ_UNIVERSE;
        }
        return SAAJ_FACTORIES.get(universe.toString()).get(factoryName);
    }

    private static boolean isAxis2InClassLoader() {
        try {
            SAAJFactoryFinder.loadClass("org.apache.axis2.saaj.MessageFactoryImpl");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    private static Object newInstance(String factoryClassName) throws SOAPException {
        try {
            Class<?> factory = null;
            try {
                factory = SAAJFactoryFinder.loadClass(factoryClassName);
            }
            catch (ClassNotFoundException cnfe) {
                factory = SAAJFactoryFinder.class.getClassLoader().loadClass(factoryClassName);
            }
            return factory.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SOAPException("Provider " + factoryClassName + " not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException("Provider " + factoryClassName + " could not be instantiated: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        SAAJ_FACTORIES.put(SAAJUniverse.Type.AXIS1.toString(), SAAJFactoryFinder.createSAAJInfo("org.apache.axis.soap.MessageFactoryImpl", "org.apache.axis.soap.SOAPFactoryImpl", "org.apache.axis.soap.SOAPConnectionFactoryImpl", "org.apache.axis.soap.SAAJMetaFactoryImpl"));
        SAAJ_FACTORIES.put(SAAJUniverse.Type.AXIS2.toString(), SAAJFactoryFinder.createSAAJInfo("org.apache.axis2.saaj.MessageFactoryImpl", "org.apache.axis2.saaj.SOAPFactoryImpl", "org.apache.axis2.saaj.SOAPConnectionFactoryImpl", "org.apache.axis2.saaj.SAAJMetaFactoryImpl"));
        SAAJ_FACTORIES.put(SAAJUniverse.Type.SUN.toString(), SAAJFactoryFinder.createSAAJInfo("com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl", "com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl"));
        SAAJFactoryFinder.initDefaultSAAJProvider();
    }
}

